/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.output;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.output.ProtocolOutputConverter;
import org.apache.qpid.server.protocol.v0_8.output.ProtocolOutputConverterImpl;

public class ProtocolOutputConverterRegistry {
    private static final Map<ProtocolVersion, ProtocolOutputConverter.Factory> _registry = new HashMap<ProtocolVersion, ProtocolOutputConverter.Factory>();

    private ProtocolOutputConverterRegistry() {
    }

    private static void register(ProtocolVersion version) {
        _registry.put(version, new ConverterFactory(version));
    }

    public static ProtocolOutputConverter getConverter(AMQProtocolSession session) {
        return _registry.get(session.getProtocolVersion()).newInstance(session);
    }

    static {
        ProtocolOutputConverterRegistry.register(ProtocolVersion.v8_0);
        ProtocolOutputConverterRegistry.register(ProtocolVersion.v0_9);
        ProtocolOutputConverterRegistry.register(ProtocolVersion.v0_91);
    }

    private static class ConverterFactory
    implements ProtocolOutputConverter.Factory {
        private ProtocolVersion _protocolVersion;
        private MethodRegistry _methodRegistry;
        private int _classId;

        public ConverterFactory(ProtocolVersion pv) {
            this._protocolVersion = pv;
        }

        public synchronized ProtocolOutputConverter newInstance(AMQProtocolSession session) {
            if (this._methodRegistry == null) {
                this._methodRegistry = MethodRegistry.getMethodRegistry((ProtocolVersion)this._protocolVersion);
            }
            return new ProtocolOutputConverterImpl(session, this._methodRegistry);
        }
    }
}

