/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import org.apache.log4j.Logger;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.store.StoredMessage;

public class AMQMessage
extends AbstractServerMessageImpl<AMQMessage, MessageMetaData> {
    private static final Logger _log = Logger.getLogger(AMQMessage.class);
    private final long _size;

    public AMQMessage(StoredMessage<MessageMetaData> handle) {
        this(handle, null);
    }

    public AMQMessage(StoredMessage<MessageMetaData> handle, Object connectionReference) {
        super(handle, connectionReference);
        this._size = ((MessageMetaData)handle.getMetaData()).getContentSize();
    }

    public MessageMetaData getMessageMetaData() {
        return (MessageMetaData)this.getStoredMessage().getMetaData();
    }

    public ContentHeaderBody getContentHeaderBody() {
        return this.getMessageMetaData().getContentHeaderBody();
    }

    public String getInitialRoutingAddress() {
        AMQShortString routingKey;
        MessageMetaData messageMetaData = this.getMessageMetaData();
        if (messageMetaData != null && (routingKey = messageMetaData.getMessagePublishInfo().getRoutingKey()) != null) {
            return routingKey.asString();
        }
        return null;
    }

    public AMQMessageHeader getMessageHeader() {
        return this.getMessageMetaData().getMessageHeader();
    }

    public MessagePublishInfo getMessagePublishInfo() {
        return this.getMessageMetaData().getMessagePublishInfo();
    }

    public long getArrivalTime() {
        return this.getMessageMetaData().getArrivalTime();
    }

    public long getSize() {
        return this._size;
    }

    public boolean isImmediate() {
        return this.getMessagePublishInfo().isImmediate();
    }

    public boolean isMandatory() {
        return this.getMessagePublishInfo().isMandatory();
    }

    public long getExpiration() {
        return this.getMessageHeader().getExpiration();
    }
}

