/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.protocol.v0_8.UnacknowledgedMessageMap;

public class ExtractResendAndRequeue
implements UnacknowledgedMessageMap.Visitor {
    private static final Logger _log = Logger.getLogger(ExtractResendAndRequeue.class);
    private final Map<Long, MessageInstance> _msgToRequeue;
    private final Map<Long, MessageInstance> _msgToResend;
    private final UnacknowledgedMessageMap _unacknowledgedMessageMap;

    public ExtractResendAndRequeue(UnacknowledgedMessageMap unacknowledgedMessageMap, Map<Long, MessageInstance> msgToRequeue, Map<Long, MessageInstance> msgToResend) {
        this._unacknowledgedMessageMap = unacknowledgedMessageMap;
        this._msgToRequeue = msgToRequeue;
        this._msgToResend = msgToResend;
    }

    @Override
    public boolean callback(long deliveryTag, MessageInstance message) throws AMQException {
        message.setRedelivered();
        ConsumerImpl consumer = message.getDeliveredConsumer();
        if (consumer != null) {
            if (!consumer.isClosed()) {
                this._msgToResend.put(deliveryTag, message);
            } else {
                this._msgToRequeue.put(deliveryTag, message);
            }
        } else {
            _log.info((Object)("No DeadLetter Queue and requeue not requested so dropping message:" + message));
        }
        return false;
    }

    @Override
    public void visitComplete() {
        this._unacknowledgedMessageMap.clear();
    }
}

