/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.message.MessageDestination;

public class IncomingMessage {
    private final MessagePublishInfo _messagePublishInfo;
    private ContentHeaderBody _contentHeaderBody;
    private MessageDestination _messageDestination;
    private long _bodyLengthReceived = 0L;
    private List<ContentBody> _contentChunks = new ArrayList<ContentBody>();

    public IncomingMessage(MessagePublishInfo info) {
        this._messagePublishInfo = info;
    }

    public void setContentHeaderBody(ContentHeaderBody contentHeaderBody) {
        this._contentHeaderBody = contentHeaderBody;
    }

    public MessagePublishInfo getMessagePublishInfo() {
        return this._messagePublishInfo;
    }

    public void addContentBodyFrame(ContentBody contentChunk) throws AMQException {
        this._bodyLengthReceived += (long)contentChunk.getSize();
        this._contentChunks.add(contentChunk);
    }

    public boolean allContentReceived() {
        return this._bodyLengthReceived == this.getContentHeader().getBodySize();
    }

    public AMQShortString getExchangeName() {
        return this._messagePublishInfo.getExchange();
    }

    public MessageDestination getDestination() {
        return this._messageDestination;
    }

    public ContentHeaderBody getContentHeader() {
        return this._contentHeaderBody;
    }

    public long getSize() {
        return this.getContentHeader().getBodySize();
    }

    public void setMessageDestination(MessageDestination e) {
        this._messageDestination = e;
    }

    public int getBodyCount() throws AMQException {
        return this._contentChunks.size();
    }

    public ContentBody getContentChunk(int index) {
        return this._contentChunks.get(index);
    }
}

