/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;
import org.apache.qpid.transport.codec.BBEncoder;

@PluggableService
public class MessageConverter_Internal_to_v0_8
implements MessageConverter<InternalMessage, AMQMessage> {
    private static final int BASIC_CLASS_ID = 60;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public Class<InternalMessage> getInputClass() {
        return InternalMessage.class;
    }

    public Class<AMQMessage> getOutputClass() {
        return AMQMessage.class;
    }

    public AMQMessage convert(InternalMessage serverMsg, VirtualHostImpl vhost) {
        return new AMQMessage(this.convertToStoredMessage(serverMsg), null);
    }

    private StoredMessage<MessageMetaData> convertToStoredMessage(final InternalMessage serverMsg) {
        final byte[] messageContent = MessageConverter_Internal_to_v0_8.convertToBody(serverMsg.getMessageBody());
        final MessageMetaData messageMetaData_0_8 = this.convertMetaData(serverMsg, MessageConverter_Internal_to_v0_8.getBodyMimeType(serverMsg.getMessageBody()), messageContent.length);
        return new StoredMessage<MessageMetaData>(){

            public MessageMetaData getMetaData() {
                return messageMetaData_0_8;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public void addContent(int offsetInMessage, ByteBuffer src) {
                throw new UnsupportedOperationException();
            }

            public int getContent(int offsetInMessage, ByteBuffer dst) {
                int size = messageContent.length - offsetInMessage;
                if (dst.remaining() < size) {
                    size = dst.remaining();
                }
                ByteBuffer buf = ByteBuffer.wrap(messageContent, offsetInMessage, size);
                dst.put(buf);
                return size;
            }

            public ByteBuffer getContent(int offsetInMessage, int size) {
                return ByteBuffer.wrap(messageContent, offsetInMessage, size);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInMemory() {
                return true;
            }

            public boolean flowToDisk() {
                return false;
            }
        };
    }

    private MessageMetaData convertMetaData(final InternalMessage serverMsg, String bodyMimeType, int size) {
        MessagePublishInfo publishInfo = new MessagePublishInfo(){

            public AMQShortString getExchange() {
                return AMQShortString.EMPTY_STRING;
            }

            public void setExchange(AMQShortString amqShortString) {
                throw new UnsupportedOperationException();
            }

            public boolean isImmediate() {
                return false;
            }

            public boolean isMandatory() {
                return false;
            }

            public AMQShortString getRoutingKey() {
                return AMQShortString.valueOf((String)serverMsg.getInitialRoutingAddress());
            }
        };
        BasicContentHeaderProperties props = new BasicContentHeaderProperties();
        props.setAppId(serverMsg.getMessageHeader().getAppId());
        props.setContentType(bodyMimeType);
        props.setCorrelationId(serverMsg.getMessageHeader().getCorrelationId());
        props.setDeliveryMode(serverMsg.isPersistent() ? (byte)2 : 1);
        props.setExpiration(serverMsg.getExpiration());
        props.setMessageId(serverMsg.getMessageHeader().getMessageId());
        props.setPriority(serverMsg.getMessageHeader().getPriority());
        props.setReplyTo(serverMsg.getMessageHeader().getReplyTo());
        props.setTimestamp(serverMsg.getMessageHeader().getTimestamp());
        props.setUserId(serverMsg.getMessageHeader().getUserId());
        LinkedHashMap<String, Object> headerProps = new LinkedHashMap<String, Object>();
        for (String headerName : serverMsg.getMessageHeader().getHeaderNames()) {
            headerProps.put(headerName, serverMsg.getMessageHeader().getHeader(headerName));
        }
        props.setHeaders(FieldTable.convertToFieldTable(headerProps));
        ContentHeaderBody chb = new ContentHeaderBody(props, 60);
        chb.setBodySize((long)size);
        return new MessageMetaData(publishInfo, chb, serverMsg.getArrivalTime());
    }

    public String getType() {
        return "Internal to v0-8";
    }

    public static byte[] convertToBody(Object object) {
        if (object instanceof String) {
            return ((String)object).getBytes(UTF_8);
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof Map) {
            BBEncoder encoder = new BBEncoder(1024);
            encoder.writeMap((Map)object);
            ByteBuffer buf = encoder.segment();
            int remaining = buf.remaining();
            byte[] data = new byte[remaining];
            buf.get(data);
            return data;
        }
        if (object instanceof List) {
            BBEncoder encoder = new BBEncoder(1024);
            encoder.writeList((List)object);
            ByteBuffer buf = encoder.segment();
            int remaining = buf.remaining();
            byte[] data = new byte[remaining];
            buf.get(data);
            return data;
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bytesOut);
            os.writeObject(object);
            return bytesOut.toByteArray();
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
    }

    public static String getBodyMimeType(Object object) {
        if (object instanceof String) {
            return "text/plain";
        }
        if (object instanceof byte[]) {
            return "application/octet-stream";
        }
        if (object instanceof Map) {
            return "amqp/map";
        }
        if (object instanceof List) {
            return "amqp/list";
        }
        return "application/java-object-stream";
    }
}

