/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.io.EOFException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.typedmessage.TypedBytesContentReader;
import org.apache.qpid.typedmessage.TypedBytesFormatException;
import org.apache.qpid.url.AMQBindingURL;

@PluggableService
public class MessageConverter_v0_8_to_Internal
implements MessageConverter<AMQMessage, InternalMessage> {
    public Class<AMQMessage> getInputClass() {
        return AMQMessage.class;
    }

    public Class<InternalMessage> getOutputClass() {
        return InternalMessage.class;
    }

    public InternalMessage convert(AMQMessage serverMessage, VirtualHostImpl vhost) {
        String mimeType = serverMessage.getMessageHeader().getMimeType();
        byte[] data = new byte[(int)serverMessage.getSize()];
        serverMessage.getContent(ByteBuffer.wrap(data), 0);
        Object body = MessageConverter_v0_8_to_Internal.convertMessageBody(mimeType, data);
        return InternalMessage.convert((long)serverMessage.getMessageNumber(), (boolean)serverMessage.isPersistent(), (AMQMessageHeader)new DelegatingMessageHeader(serverMessage.getMessageHeader()), (Object)body);
    }

    private static Object convertMessageBody(String mimeType, byte[] data) {
        if ("text/plain".equals(mimeType) || "text/xml".equals(mimeType)) {
            String text = new String(data);
            return text;
        }
        if ("jms/map-message".equals(mimeType)) {
            TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            int entries = reader.readIntImpl();
            for (int i = 0; i < entries; ++i) {
                try {
                    String propName = reader.readStringImpl();
                    Object value = reader.readObject();
                    map.put(propName, value);
                    continue;
                }
                catch (EOFException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (TypedBytesFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return map;
        }
        if ("amqp/map".equals(mimeType)) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(ByteBuffer.wrap(data));
            Map map = decoder.readMap();
            return map;
        }
        if ("amqp/list".equals(mimeType)) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(ByteBuffer.wrap(data));
            return decoder.readList();
        }
        if ("jms/stream-message".equals(mimeType)) {
            TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
            ArrayList<Object> list = new ArrayList<Object>();
            while (reader.remaining() != 0) {
                try {
                    list.add(reader.readObject());
                }
                catch (TypedBytesFormatException e) {
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
                catch (EOFException e) {
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
            }
            return list;
        }
        return data;
    }

    public String getType() {
        return "v0-8 to Internal";
    }

    private static class DelegatingMessageHeader
    implements AMQMessageHeader {
        private final AMQMessageHeader _delegate;

        private DelegatingMessageHeader(AMQMessageHeader delegate) {
            this._delegate = delegate;
        }

        public String getCorrelationId() {
            return this._delegate.getCorrelationId();
        }

        public long getExpiration() {
            return this._delegate.getExpiration();
        }

        public String getUserId() {
            return this._delegate.getUserId();
        }

        public String getAppId() {
            return this._delegate.getAppId();
        }

        public String getMessageId() {
            return this._delegate.getMessageId();
        }

        public String getMimeType() {
            return this._delegate.getMimeType();
        }

        public String getEncoding() {
            return this._delegate.getEncoding();
        }

        public byte getPriority() {
            return this._delegate.getPriority();
        }

        public long getTimestamp() {
            return this._delegate.getTimestamp();
        }

        public String getType() {
            return this._delegate.getType();
        }

        public String getReplyTo() {
            String originalReplyTo = this._delegate.getReplyTo();
            ReplyToComponents replyTo = this.convertReplyTo(originalReplyTo);
            if (replyTo != null) {
                if (replyTo.hasExchange()) {
                    return replyTo.getExchange() + (replyTo.hasRoutingKey() ? "/" + replyTo.getRoutingKey() : "");
                }
                return replyTo.hasQueue() ? replyTo.getQueue() : replyTo.getRoutingKey();
            }
            return originalReplyTo;
        }

        private ReplyToComponents convertReplyTo(String origReplyToString) {
            try {
                AMQShortString queueName;
                AMQShortString exchangeName;
                AMQBindingURL burl = new AMQBindingURL(origReplyToString);
                ReplyToComponents replyTo = new ReplyToComponents();
                AMQShortString routingKey = burl.getRoutingKey();
                if (routingKey != null) {
                    replyTo.setRoutingKey(routingKey.asString());
                }
                if ((exchangeName = burl.getExchangeName()) != null) {
                    replyTo.setExchange(exchangeName.asString());
                }
                if ((queueName = burl.getQueueName()) != null) {
                    replyTo.setQueue(queueName.asString());
                }
                return replyTo;
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        public Object getHeader(String name) {
            return this._delegate.getHeader(name);
        }

        public boolean containsHeaders(Set<String> names) {
            return this._delegate.containsHeaders(names);
        }

        public boolean containsHeader(String name) {
            return this._delegate.containsHeader(name);
        }

        public Collection<String> getHeaderNames() {
            return this._delegate.getHeaderNames();
        }
    }

    private static class ReplyToComponents {
        private String _exchange;
        private String _queue;
        private String _routingKey;

        private ReplyToComponents() {
        }

        public void setExchange(String exchange) {
            this._exchange = exchange;
        }

        public void setQueue(String queue) {
            this._queue = queue;
        }

        public void setRoutingKey(String routingKey) {
            this._routingKey = routingKey;
        }

        public String getExchange() {
            return this._exchange;
        }

        public String getQueue() {
            return this._queue;
        }

        public String getRoutingKey() {
            return this._routingKey;
        }

        public boolean hasExchange() {
            return this._exchange != null;
        }

        public boolean hasQueue() {
            return this._queue != null;
        }

        public boolean hasRoutingKey() {
            return this._routingKey != null;
        }
    }
}

