/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Set;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQProtocolVersionException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.protocol.v0_8.MessageMetaDataType_0_8;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.util.ByteBufferOutputStream;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.util.ByteBufferInputStream;

public class MessageMetaData
implements StorableMessageMetaData {
    private final MessagePublishInfo _messagePublishInfo;
    private final ContentHeaderBody _contentHeaderBody;
    private long _arrivalTime;
    private static final byte MANDATORY_FLAG = 1;
    private static final byte IMMEDIATE_FLAG = 2;
    public static final MessageMetaDataType.Factory<MessageMetaData> FACTORY = new MetaDataFactory();
    private static final MessageMetaDataType_0_8 TYPE = new MessageMetaDataType_0_8();

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody) {
        this(publishBody, contentHeaderBody, System.currentTimeMillis());
    }

    public MessageMetaData(MessagePublishInfo publishBody, ContentHeaderBody contentHeaderBody, long arrivalTime) {
        this._contentHeaderBody = contentHeaderBody;
        this._messagePublishInfo = publishBody;
        this._arrivalTime = arrivalTime;
    }

    public ContentHeaderBody getContentHeaderBody() {
        return this._contentHeaderBody;
    }

    public MessagePublishInfo getMessagePublishInfo() {
        return this._messagePublishInfo;
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }

    public MessageMetaDataType getType() {
        return TYPE;
    }

    public int getStorableSize() {
        int size = this._contentHeaderBody.getSize();
        size += 4;
        size += EncodingUtils.encodedShortStringLength((AMQShortString)this._messagePublishInfo.getExchange());
        size += EncodingUtils.encodedShortStringLength((AMQShortString)this._messagePublishInfo.getRoutingKey());
        ++size;
        return size += EncodingUtils.encodedLongLength();
    }

    public int writeToBuffer(ByteBuffer dest) {
        int oldPosition = dest.position();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)new ByteBufferOutputStream(dest));
            EncodingUtils.writeInteger((DataOutput)dataOutputStream, (int)this._contentHeaderBody.getSize());
            this._contentHeaderBody.writePayload((DataOutput)dataOutputStream);
            EncodingUtils.writeShortStringBytes((DataOutput)dataOutputStream, (AMQShortString)this._messagePublishInfo.getExchange());
            EncodingUtils.writeShortStringBytes((DataOutput)dataOutputStream, (AMQShortString)this._messagePublishInfo.getRoutingKey());
            byte flags = 0;
            if (this._messagePublishInfo.isMandatory()) {
                flags = (byte)(flags | 1);
            }
            if (this._messagePublishInfo.isImmediate()) {
                flags = (byte)(flags | 2);
            }
            dest.put(flags);
            dest.putLong(this._arrivalTime);
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
        return dest.position() - oldPosition;
    }

    public int getContentSize() {
        return (int)this._contentHeaderBody.getBodySize();
    }

    public boolean isPersistent() {
        return this._contentHeaderBody.getProperties().getDeliveryMode() == 2;
    }

    public AMQMessageHeader getMessageHeader() {
        return new MessageHeaderAdapter();
    }

    private final class MessageHeaderAdapter
    implements AMQMessageHeader {
        private MessageHeaderAdapter() {
        }

        private BasicContentHeaderProperties getProperties() {
            return MessageMetaData.this.getContentHeaderBody().getProperties();
        }

        public String getUserId() {
            return this.getProperties().getUserIdAsString();
        }

        public String getAppId() {
            return this.getProperties().getAppIdAsString();
        }

        public String getCorrelationId() {
            return this.getProperties().getCorrelationIdAsString();
        }

        public long getExpiration() {
            return this.getProperties().getExpiration();
        }

        public String getMessageId() {
            return this.getProperties().getMessageIdAsString();
        }

        public String getMimeType() {
            return this.getProperties().getContentTypeAsString();
        }

        public String getEncoding() {
            return this.getProperties().getEncodingAsString();
        }

        public byte getPriority() {
            return this.getProperties().getPriority();
        }

        public long getTimestamp() {
            return this.getProperties().getTimestamp();
        }

        public String getType() {
            return this.getProperties().getTypeAsString();
        }

        public String getReplyTo() {
            return this.getProperties().getReplyToAsString();
        }

        public Object getHeader(String name) {
            FieldTable ft = this.getProperties().getHeaders();
            return ft.get(name);
        }

        public boolean containsHeaders(Set<String> names) {
            FieldTable ft = this.getProperties().getHeaders();
            for (String name : names) {
                if (ft.containsKey(name)) continue;
                return false;
            }
            return true;
        }

        public Collection<String> getHeaderNames() {
            return this.getProperties().getHeaders().keys();
        }

        public boolean containsHeader(String name) {
            FieldTable ft = this.getProperties().getHeaders();
            return ft.containsKey(name);
        }
    }

    private static class MetaDataFactory
    implements MessageMetaDataType.Factory {
        private MetaDataFactory() {
        }

        public MessageMetaData createMetaData(ByteBuffer buf) {
            try {
                ByteBufferInputStream bbis = new ByteBufferInputStream(buf);
                DataInputStream dais = new DataInputStream((InputStream)bbis);
                int size = EncodingUtils.readInteger((DataInput)dais);
                ContentHeaderBody chb = ContentHeaderBody.createFromBuffer((DataInputStream)dais, (long)size);
                final AMQShortString exchange = EncodingUtils.readAMQShortString((DataInput)dais);
                final AMQShortString routingKey = EncodingUtils.readAMQShortString((DataInput)dais);
                final byte flags = EncodingUtils.readByte((DataInput)dais);
                long arrivalTime = EncodingUtils.readLong((DataInput)dais);
                MessagePublishInfo publishBody = new MessagePublishInfo(){

                    public AMQShortString getExchange() {
                        return exchange;
                    }

                    public void setExchange(AMQShortString exchange2) {
                    }

                    public boolean isImmediate() {
                        return (flags & 2) != 0;
                    }

                    public boolean isMandatory() {
                        return (flags & 1) != 0;
                    }

                    public AMQShortString getRoutingKey() {
                        return routingKey;
                    }
                };
                return new MessageMetaData(publishBody, chb, arrivalTime);
            }
            catch (IOException e) {
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
            catch (AMQProtocolVersionException e) {
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
            catch (AMQFrameDecodingException e) {
                throw new ConnectionScopedRuntimeException((Throwable)e);
            }
        }
    }
}

