/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.protocol.v0_8.UnacknowledgedMessageMap;

public class UnacknowledgedMessageMapImpl
implements UnacknowledgedMessageMap {
    private final Object _lock = new Object();
    private Map<Long, MessageInstance> _map;
    private final int _prefetchLimit;

    public UnacknowledgedMessageMapImpl(int prefetchLimit) {
        this._prefetchLimit = prefetchLimit;
        this._map = new LinkedHashMap<Long, MessageInstance>(prefetchLimit);
    }

    public void collect(long deliveryTag, boolean multiple, Map<Long, MessageInstance> msgs) {
        if (multiple) {
            this.collect(deliveryTag, msgs);
        } else {
            MessageInstance entry = this.get(deliveryTag);
            if (entry != null) {
                msgs.put(deliveryTag, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Map<Long, MessageInstance> msgs) {
        Object object = this._lock;
        synchronized (object) {
            for (Long deliveryTag : msgs.keySet()) {
                this.remove(deliveryTag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageInstance remove(long deliveryTag) {
        Object object = this._lock;
        synchronized (object) {
            MessageInstance message = this._map.remove(deliveryTag);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(UnacknowledgedMessageMap.Visitor visitor) throws AMQException {
        Object object = this._lock;
        synchronized (object) {
            Set<Map.Entry<Long, MessageInstance>> currentEntries = this._map.entrySet();
            for (Map.Entry<Long, MessageInstance> entry : currentEntries) {
                visitor.callback(entry.getKey(), entry.getValue());
            }
            visitor.visitComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(long deliveryTag, MessageInstance message) {
        Object object = this._lock;
        synchronized (object) {
            this._map.put(deliveryTag, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<MessageInstance> cancelAllMessages() {
        Object object = this._lock;
        synchronized (object) {
            Collection<MessageInstance> currentEntries = this._map.values();
            this._map = new LinkedHashMap<Long, MessageInstance>(this._prefetchLimit);
            return currentEntries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this._lock;
        synchronized (object) {
            return this._map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageInstance get(long key) {
        Object object = this._lock;
        synchronized (object) {
            return this._map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getDeliveryTags() {
        Object object = this._lock;
        synchronized (object) {
            return this._map.keySet();
        }
    }

    @Override
    public Collection<MessageInstance> acknowledge(long deliveryTag, boolean multiple) {
        LinkedHashMap<Long, MessageInstance> ackedMessageMap = new LinkedHashMap<Long, MessageInstance>();
        this.collect(deliveryTag, multiple, ackedMessageMap);
        this.remove(ackedMessageMap);
        ArrayList<MessageInstance> acknowledged = new ArrayList<MessageInstance>();
        for (MessageInstance instance : ackedMessageMap.values()) {
            if (!instance.lockAcquisition()) continue;
            acknowledged.add(instance);
        }
        return acknowledged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collect(long key, Map<Long, MessageInstance> msgs) {
        Object object = this._lock;
        synchronized (object) {
            for (Map.Entry<Long, MessageInstance> entry : this._map.entrySet()) {
                msgs.put(entry.getKey(), entry.getValue());
                if (entry.getKey() != key) continue;
                break;
            }
        }
    }
}

