/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.BasicAckBody;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;

public class BasicAckMethodHandler
implements StateAwareMethodListener<BasicAckBody> {
    private static final Logger _log = Logger.getLogger(BasicAckMethodHandler.class);
    private static final BasicAckMethodHandler _instance = new BasicAckMethodHandler();

    public static BasicAckMethodHandler getInstance() {
        return _instance;
    }

    private BasicAckMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicAckBody body, int channelId) throws AMQException {
        AMQChannel channel;
        AMQProtocolSession protocolSession = stateManager.getProtocolSession();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Ack(Tag:" + body.getDeliveryTag() + ":Mult:" + body.getMultiple() + ") received on channel " + channelId));
        }
        if ((channel = protocolSession.getChannel(channelId)) == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.acknowledgeMessage(body.getDeliveryTag(), body.getMultiple());
    }
}

