/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import java.security.AccessControlException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicConsumeBody;
import org.apache.qpid.framing.BasicConsumeOkBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;

public class BasicConsumeMethodHandler
implements StateAwareMethodListener<BasicConsumeBody> {
    private static final Logger _logger = Logger.getLogger(BasicConsumeMethodHandler.class);
    private static final BasicConsumeMethodHandler _instance = new BasicConsumeMethodHandler();

    public static BasicConsumeMethodHandler getInstance() {
        return _instance;
    }

    private BasicConsumeMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicConsumeBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        VirtualHostImpl<?, ?, ?> vHost = protocolConnection.getVirtualHost();
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.sync();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("BasicConsume: from '" + body.getQueue() + "' for:" + body.getConsumerTag() + " nowait:" + body.getNowait() + " args:" + body.getArguments()));
        }
        AMQQueue aMQQueue = queue = body.getQueue() == null ? channel.getDefaultQueue() : vHost.getQueue(body.getQueue().intern().toString());
        if (queue == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("No queue for '" + body.getQueue() + "'"));
            }
            if (body.getQueue() != null) {
                String msg = "No such queue, '" + body.getQueue() + "'";
                throw body.getChannelException(AMQConstant.NOT_FOUND, msg);
            }
            String msg = "No queue name provided, no default queue defined.";
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, msg);
        }
        AMQShortString consumerTagName = body.getConsumerTag() != null ? body.getConsumerTag().intern(false) : null;
        try {
            if (consumerTagName == null || channel.getSubscription(consumerTagName) == null) {
                AMQShortString consumerTag = channel.consumeFromSource(consumerTagName, (MessageSource)queue, !body.getNoAck(), body.getArguments(), body.getExclusive(), body.getNoLocal());
                if (!body.getNowait()) {
                    MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
                    BasicConsumeOkBody responseBody = methodRegistry.createBasicConsumeOkBody(consumerTag);
                    protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
                }
            } else {
                AMQShortString msg = AMQShortString.validValueOf((Object)("Non-unique consumer tag, '" + body.getConsumerTag() + "'"));
                MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
                ConnectionCloseBody responseBody = methodRegistry.createConnectionCloseBody(AMQConstant.NOT_ALLOWED.getCode(), msg, body.getClazz(), body.getMethod());
                protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(0));
            }
        }
        catch (AMQInvalidArgumentException ise) {
            _logger.debug((Object)"Closing connection due to invalid selector");
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            ChannelCloseBody responseBody = methodRegistry.createChannelCloseBody(AMQConstant.ARGUMENT_INVALID.getCode(), AMQShortString.validValueOf((Object)ise.getMessage()), body.getClazz(), body.getMethod());
            protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
        catch (MessageSource.ExistingExclusiveConsumer e) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "Cannot subscribe to queue " + queue.getName() + " as it already has an existing exclusive consumer");
        }
        catch (MessageSource.ExistingConsumerPreventsExclusive e) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "Cannot subscribe to queue " + queue.getName() + " exclusively as it already has a consumer");
        }
        catch (AccessControlException e) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "Cannot subscribe to queue " + queue.getName() + " permission denied");
        }
        catch (MessageSource.ConsumerAccessRefused consumerAccessRefused) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, "Cannot subscribe to queue " + queue.getName() + " as it already has an incompatible exclusivity policy");
        }
    }
}

