/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import java.security.AccessControlException;
import java.util.EnumSet;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicGetBody;
import org.apache.qpid.framing.BasicGetEmptyBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.flow.MessageOnlyCreditManager;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.ClientDeliveryMethod;
import org.apache.qpid.server.protocol.v0_8.ConsumerTarget_0_8;
import org.apache.qpid.server.protocol.v0_8.RecordDeliveryMethod;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;

public class BasicGetMethodHandler
implements StateAwareMethodListener<BasicGetBody> {
    private static final Logger _log = Logger.getLogger(BasicGetMethodHandler.class);
    private static final BasicGetMethodHandler _instance = new BasicGetMethodHandler();

    public static BasicGetMethodHandler getInstance() {
        return _instance;
    }

    private BasicGetMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicGetBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHostImpl<?, ?, ?> vHost = protocolConnection.getVirtualHost();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.sync();
        AMQQueue aMQQueue = queue = body.getQueue() == null ? channel.getDefaultQueue() : vHost.getQueue(body.getQueue().toString());
        if (queue == null) {
            _log.info((Object)("No queue for '" + body.getQueue() + "'"));
            if (body.getQueue() != null) {
                throw body.getConnectionException(AMQConstant.NOT_FOUND, "No such queue, '" + body.getQueue() + "'");
            }
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "No queue name provided, no default queue defined.");
        }
        try {
            if (!BasicGetMethodHandler.performGet(queue, protocolConnection, channel, !body.getNoAck())) {
                MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
                BasicGetEmptyBody responseBody = methodRegistry.createBasicGetEmptyBody(null);
                protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
            }
        }
        catch (AccessControlException e) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, e.getMessage());
        }
        catch (MessageSource.ExistingExclusiveConsumer e) {
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue has an exclusive consumer");
        }
        catch (MessageSource.ExistingConsumerPreventsExclusive e) {
            throw body.getConnectionException(AMQConstant.INTERNAL_ERROR, "The GET request has been evaluated as an exclusive consumer, this is likely due to a programming error in the Qpid broker");
        }
        catch (MessageSource.ConsumerAccessRefused consumerAccessRefused) {
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue has an incompatible exclusivit policy");
        }
    }

    public static boolean performGet(AMQQueue queue, AMQProtocolSession session, final AMQChannel channel, boolean acks) throws AMQException, MessageSource.ExistingConsumerPreventsExclusive, MessageSource.ExistingExclusiveConsumer, MessageSource.ConsumerAccessRefused {
        MessageOnlyCreditManager singleMessageCredit = new MessageOnlyCreditManager(1L);
        GetDeliveryMethod getDeliveryMethod = new GetDeliveryMethod((FlowCreditManager)singleMessageCredit, session, channel, queue);
        RecordDeliveryMethod getRecordMethod = new RecordDeliveryMethod(){

            @Override
            public void recordMessageDelivery(ConsumerImpl sub, MessageInstance entry, long deliveryTag) {
                channel.addUnacknowledgedMessage(entry, deliveryTag, null);
            }
        };
        EnumSet<ConsumerImpl.Option> options = EnumSet.of(ConsumerImpl.Option.TRANSIENT, ConsumerImpl.Option.ACQUIRES, ConsumerImpl.Option.SEES_REQUEUES);
        ConsumerTarget_0_8 target = acks ? ConsumerTarget_0_8.createAckTarget(channel, AMQShortString.EMPTY_STRING, null, (FlowCreditManager)singleMessageCredit, getDeliveryMethod, getRecordMethod) : ConsumerTarget_0_8.createGetNoAckTarget(channel, AMQShortString.EMPTY_STRING, null, (FlowCreditManager)singleMessageCredit, getDeliveryMethod, getRecordMethod);
        ConsumerImpl sub = queue.addConsumer((ConsumerTarget)target, null, AMQMessage.class, "", options);
        sub.flush();
        sub.close();
        return getDeliveryMethod.hasDeliveredMessage();
    }

    private static class GetDeliveryMethod
    implements ClientDeliveryMethod {
        private final FlowCreditManager _singleMessageCredit;
        private final AMQProtocolSession _session;
        private final AMQChannel _channel;
        private final AMQQueue _queue;
        private boolean _deliveredMessage;

        public GetDeliveryMethod(FlowCreditManager singleMessageCredit, AMQProtocolSession session, AMQChannel channel, AMQQueue queue) {
            this._singleMessageCredit = singleMessageCredit;
            this._session = session;
            this._channel = channel;
            this._queue = queue;
        }

        @Override
        public long deliverToClient(ConsumerImpl sub, ServerMessage message, InstanceProperties props, long deliveryTag) {
            this._singleMessageCredit.useCreditForMessage(message.getSize());
            long size = this._session.getProtocolOutputConverter().writeGetOk(message, props, this._channel.getChannelId(), deliveryTag, this._queue.getQueueDepthMessages());
            this._deliveredMessage = true;
            return size;
        }

        public boolean hasDeliveredMessage() {
            return this._deliveredMessage;
        }
    }
}

