/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import java.security.AccessControlException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.abstraction.MessagePublishInfo;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;

public class BasicPublishMethodHandler
implements StateAwareMethodListener<BasicPublishBody> {
    private static final Logger _logger = Logger.getLogger(BasicPublishMethodHandler.class);
    private static final BasicPublishMethodHandler _instance = new BasicPublishMethodHandler();

    public static BasicPublishMethodHandler getInstance() {
        return _instance;
    }

    private BasicPublishMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicPublishBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Publish received on channel " + channelId));
        }
        AMQShortString exchangeName = body.getExchange();
        VirtualHostImpl<?, ?, ?> vHost = session.getVirtualHost();
        MessageDestination destination = exchangeName == null || AMQShortString.EMPTY_STRING.equals(exchangeName) ? vHost.getDefaultDestination() : vHost.getMessageDestination(exchangeName.toString());
        if (destination == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Unknown exchange name");
        }
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        MessagePublishInfo info = session.getMethodRegistry().getProtocolVersionMethodConverter().convertToInfo((AMQMethodBody)body);
        info.setExchange(exchangeName);
        try {
            channel.setPublishFrame(info, destination);
        }
        catch (AccessControlException e) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, e.getMessage());
        }
    }
}

