/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.BasicRejectBody;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;

public class BasicRejectMethodHandler
implements StateAwareMethodListener<BasicRejectBody> {
    private static final Logger _logger = Logger.getLogger(BasicRejectMethodHandler.class);
    private static BasicRejectMethodHandler _instance = new BasicRejectMethodHandler();

    public static BasicRejectMethodHandler getInstance() {
        return _instance;
    }

    private BasicRejectMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicRejectBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Rejecting:" + body.getDeliveryTag() + ": Requeue:" + body.getRequeue() + " on channel:" + channel.debugIdentity()));
        }
        long deliveryTag = body.getDeliveryTag();
        MessageInstance message = channel.getUnacknowledgedMessageMap().get(deliveryTag);
        if (message == null) {
            _logger.warn((Object)("Dropping reject request as message is null for tag:" + deliveryTag));
        } else {
            if (message.getMessage() == null) {
                _logger.warn((Object)"Message has already been purged, unable to Reject.");
                return;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Rejecting: DT:" + deliveryTag + "-" + message.getMessage() + ": Requeue:" + body.getRequeue() + " on channel:" + channel.debugIdentity()));
            }
            if (body.getRequeue()) {
                message.decrementDeliveryCount();
                channel.requeue(deliveryTag);
            } else {
                boolean maxDeliveryCountEnabled = channel.isMaxDeliveryCountEnabled(deliveryTag);
                _logger.debug((Object)("maxDeliveryCountEnabled: " + maxDeliveryCountEnabled + " deliveryTag " + deliveryTag));
                if (maxDeliveryCountEnabled) {
                    boolean deliveredTooManyTimes = channel.isDeliveredTooManyTimes(deliveryTag);
                    _logger.debug((Object)("deliveredTooManyTimes: " + deliveredTooManyTimes + " deliveryTag " + deliveryTag));
                    if (deliveredTooManyTimes) {
                        channel.deadLetter(body.getDeliveryTag());
                    } else {
                        message.incrementDeliveryCount();
                    }
                } else {
                    channel.requeue(deliveryTag);
                }
            }
        }
    }
}

