/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ChannelFlowBody;
import org.apache.qpid.framing.ChannelFlowOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;

public class ChannelFlowHandler
implements StateAwareMethodListener<ChannelFlowBody> {
    private static final Logger _logger = Logger.getLogger(ChannelFlowHandler.class);
    private static ChannelFlowHandler _instance = new ChannelFlowHandler();

    public static ChannelFlowHandler getInstance() {
        return _instance;
    }

    private ChannelFlowHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ChannelFlowBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.sync();
        channel.setSuspended(!body.getActive());
        _logger.debug((Object)("Channel.Flow for channel " + channelId + ", active=" + body.getActive()));
        MethodRegistry methodRegistry = session.getMethodRegistry();
        ChannelFlowOkBody responseBody = methodRegistry.createChannelFlowOkBody(body.getActive());
        session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
    }
}

