/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQState;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;

public class ConnectionCloseOkMethodHandler
implements StateAwareMethodListener<ConnectionCloseOkBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionCloseOkMethodHandler.class);
    private static ConnectionCloseOkMethodHandler _instance = new ConnectionCloseOkMethodHandler();

    public static ConnectionCloseOkMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionCloseOkMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionCloseOkBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        _logger.info((Object)"Received Connection-close-ok");
        try {
            stateManager.changeState(AMQState.CONNECTION_CLOSED);
            session.closeSession();
        }
        catch (Exception e) {
            _logger.error((Object)("Error closing protocol session: " + e), (Throwable)e);
        }
    }
}

