/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQState;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;

public class ConnectionStartOkMethodHandler
implements StateAwareMethodListener<ConnectionStartOkBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionStartOkMethodHandler.class);
    private static ConnectionStartOkMethodHandler _instance = new ConnectionStartOkMethodHandler();

    public static ConnectionStartOkMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionStartOkMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionStartOkBody body, int channelId) throws AMQException {
        Broker<?> broker = stateManager.getBroker();
        AMQProtocolSession session = stateManager.getProtocolSession();
        _logger.info((Object)("SASL Mechanism selected: " + body.getMechanism()));
        _logger.info((Object)("Locale selected: " + body.getLocale()));
        SubjectCreator subjectCreator = stateManager.getSubjectCreator();
        SaslServer ss = null;
        try {
            ss = subjectCreator.createSaslServer(String.valueOf(body.getMechanism()), session.getLocalFQDN(), session.getPeerPrincipal());
            if (ss == null) {
                throw body.getConnectionException(AMQConstant.RESOURCE_ERROR, "Unable to create SASL Server:" + body.getMechanism());
            }
            session.setSaslServer(ss);
            SubjectAuthenticationResult authResult = subjectCreator.authenticate(ss, body.getResponse());
            session.setClientProperties(body.getClientProperties());
            MethodRegistry methodRegistry = session.getMethodRegistry();
            switch (authResult.getStatus()) {
                case ERROR: {
                    Exception cause = authResult.getCause();
                    _logger.info((Object)("Authentication failed:" + (cause == null ? "" : cause.getMessage())));
                    stateManager.changeState(AMQState.CONNECTION_CLOSING);
                    ConnectionCloseBody closeBody = methodRegistry.createConnectionCloseBody(AMQConstant.NOT_ALLOWED.getCode(), AMQConstant.NOT_ALLOWED.getName(), body.getClazz(), body.getMethod());
                    session.writeFrame((AMQDataBlock)closeBody.generateFrame(0));
                    this.disposeSaslServer(session);
                    break;
                }
                case SUCCESS: {
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)("Connected as: " + authResult.getSubject()));
                    }
                    session.setAuthorizedSubject(authResult.getSubject());
                    stateManager.changeState(AMQState.CONNECTION_NOT_TUNED);
                    ConnectionTuneBody tuneBody = methodRegistry.createConnectionTuneBody(broker.getConnection_sessionCountLimit(), ((Long)broker.getContextValue(Long.class, "qpid.broker_frame_size")).longValue(), broker.getConnection_heartBeatDelay());
                    session.writeFrame((AMQDataBlock)tuneBody.generateFrame(0));
                    break;
                }
                case CONTINUE: {
                    stateManager.changeState(AMQState.CONNECTION_NOT_AUTH);
                    ConnectionSecureBody secureBody = methodRegistry.createConnectionSecureBody(authResult.getChallenge());
                    session.writeFrame((AMQDataBlock)secureBody.generateFrame(0));
                }
            }
        }
        catch (SaslException e) {
            this.disposeSaslServer(session);
            throw new AMQException("SASL error: " + e, (Throwable)e);
        }
    }

    private void disposeSaslServer(AMQProtocolSession ps) {
        SaslServer ss = ps.getSaslServer();
        if (ss != null) {
            ps.setSaslServer(null);
            try {
                ss.dispose();
            }
            catch (SaslException e) {
                _logger.error((Object)("Error disposing of Sasl server: " + e));
            }
        }
    }
}

