/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.ConnectionTuneOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQState;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;

public class ConnectionTuneOkMethodHandler
implements StateAwareMethodListener<ConnectionTuneOkBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionTuneOkMethodHandler.class);
    private static ConnectionTuneOkMethodHandler _instance = new ConnectionTuneOkMethodHandler();

    public static ConnectionTuneOkMethodHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionTuneOkBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)body);
        }
        stateManager.changeState(AMQState.CONNECTION_NOT_OPENED);
        session.initHeartbeats(body.getHeartbeat());
        long brokerFrameMax = (Long)stateManager.getBroker().getContextValue(Long.class, "qpid.broker_frame_size");
        if (brokerFrameMax != 0L && body.getFrameMax() > brokerFrameMax) {
            throw new AMQConnectionException(AMQConstant.SYNTAX_ERROR, "Attempt to set max frame size to " + body.getFrameMax() + "greater than the broker will allow: " + brokerFrameMax, body.getClazz(), body.getMethod(), body.getMajor(), body.getMinor(), null);
        }
        if (body.getFrameMax() > 0L && body.getFrameMax() < (long)AMQConstant.FRAME_MIN_SIZE.getCode()) {
            throw new AMQConnectionException(AMQConstant.SYNTAX_ERROR, "Attempt to set max frame size to " + body.getFrameMax() + "which is smaller than the specification definined minimum: " + AMQConstant.FRAME_MIN_SIZE.getCode(), body.getClazz(), body.getMethod(), body.getMajor(), body.getMinor(), null);
        }
        session.setMaxFrameSize(body.getFrameMax() == 0L ? (brokerFrameMax == 0L ? 0xFFFFFFFFL : brokerFrameMax) : body.getFrameMax());
        long maxChannelNumber = body.getChannelMax();
        session.setMaximumNumberOfChannels(maxChannelNumber == 0L ? 65535L : maxChannelNumber);
    }
}

