/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import java.security.AccessControlException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.ExchangeDeclareOkBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.ExchangeImpl;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.NoFactoryForTypeException;
import org.apache.qpid.server.model.UnknownConfiguredObjectException;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.ExchangeExistsException;
import org.apache.qpid.server.virtualhost.ReservedExchangeNameException;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;

public class ExchangeDeclareHandler
implements StateAwareMethodListener<ExchangeDeclareBody> {
    private static final Logger _logger = Logger.getLogger(ExchangeDeclareHandler.class);
    private static final ExchangeDeclareHandler _instance = new ExchangeDeclareHandler();

    public static ExchangeDeclareHandler getInstance() {
        return _instance;
    }

    private ExchangeDeclareHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ExchangeDeclareBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHostImpl<?, ?, ?> virtualHost = session.getVirtualHost();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        AMQShortString exchangeName = body.getExchange();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Request to declare exchange of type " + body.getType() + " with name " + exchangeName));
        }
        if (this.isDefaultExchange(exchangeName)) {
            if (!new AMQShortString("direct").equals(body.getType())) {
                throw new AMQConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to redeclare default exchange:  of type direct to " + body.getType() + ".", body.getClazz(), body.getMethod(), body.getMajor(), body.getMinor(), null);
            }
        } else if (body.getPassive()) {
            ExchangeImpl exchange = virtualHost.getExchange(exchangeName.toString());
            if (exchange == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "Unknown exchange: " + exchangeName);
            }
            if (body.getType() != null && body.getType().length() != 0 && !exchange.getType().equals(body.getType().asString())) {
                throw new AMQConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getType() + " to " + body.getType() + ".", body.getClazz(), body.getMethod(), body.getMajor(), body.getMinor(), null);
            }
        } else {
            try {
                String name = exchangeName == null ? null : exchangeName.intern().toString();
                String type = body.getType() == null ? null : body.getType().intern().toString();
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                if (body.getArguments() != null) {
                    attributes.putAll(FieldTable.convertToMap((FieldTable)body.getArguments()));
                }
                attributes.put("id", null);
                attributes.put("name", name);
                attributes.put("type", type);
                attributes.put("durable", body.getDurable());
                attributes.put("lifetimePolicy", body.getAutoDelete() ? LifetimePolicy.DELETE_ON_NO_LINKS : LifetimePolicy.PERMANENT);
                if (!attributes.containsKey("alternateExchange")) {
                    attributes.put("alternateExchange", null);
                }
                ExchangeImpl exchange = virtualHost.createExchange(attributes);
            }
            catch (ReservedExchangeNameException e) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to declare exchange: " + exchangeName + " which begins with reserved prefix.");
            }
            catch (ExchangeExistsException e) {
                ExchangeImpl exchange = e.getExistingExchange();
                if (!new AMQShortString(exchange.getType()).equals(body.getType())) {
                    throw new AMQConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to redeclare exchange: " + exchangeName + " of type " + exchange.getType() + " to " + body.getType() + ".", body.getClazz(), body.getMethod(), body.getMajor(), body.getMinor(), null);
                }
            }
            catch (NoFactoryForTypeException e) {
                throw body.getConnectionException(AMQConstant.COMMAND_INVALID, "Unknown exchange: " + exchangeName, (Throwable)e);
            }
            catch (AccessControlException e) {
                throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, e.getMessage());
            }
            catch (UnknownConfiguredObjectException e) {
                throw body.getConnectionException(AMQConstant.NOT_FOUND, "Unknown alternate exchange", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw body.getConnectionException(AMQConstant.COMMAND_INVALID, "Error creating exchange", (Throwable)e);
            }
        }
        if (!body.getNowait()) {
            MethodRegistry methodRegistry = session.getMethodRegistry();
            ExchangeDeclareOkBody responseBody = methodRegistry.createExchangeDeclareOkBody();
            channel.sync();
            session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
    }

    protected boolean isDefaultExchange(AMQShortString exchangeName) {
        return exchangeName == null || exchangeName.equals(AMQShortString.EMPTY_STRING);
    }
}

