/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import java.security.AccessControlException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueueBindBody;
import org.apache.qpid.framing.QueueBindOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.exchange.ExchangeImpl;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;

public class QueueBindHandler
implements StateAwareMethodListener<QueueBindBody> {
    private static final Logger _log = Logger.getLogger(QueueBindHandler.class);
    private static final QueueBindHandler _instance = new QueueBindHandler();

    public static QueueBindHandler getInstance() {
        return _instance;
    }

    private QueueBindHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueBindBody body, int channelId) throws AMQException {
        AMQShortString routingKey;
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHostImpl<?, ?, ?> virtualHost = protocolConnection.getVirtualHost();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        AMQShortString queueName = body.getQueue();
        if (queueName == null) {
            queue = channel.getDefaultQueue();
            if (queue == null) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "No default queue defined on channel and queue was null");
            }
            routingKey = body.getRoutingKey() == null ? AMQShortString.valueOf((String)queue.getName()) : body.getRoutingKey().intern();
        } else {
            queue = virtualHost.getQueue(queueName.toString());
            AMQShortString aMQShortString = routingKey = body.getRoutingKey() == null ? AMQShortString.EMPTY_STRING : body.getRoutingKey().intern();
        }
        if (queue == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + queueName + " does not exist.");
        }
        if (this.isDefaultExchange(body.getExchange())) {
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Cannot bind the queue " + queueName + " to the default exchange");
        }
        String exchangeName = body.getExchange().toString();
        ExchangeImpl exch = virtualHost.getExchange(exchangeName);
        if (exch == null) {
            throw body.getChannelException(AMQConstant.NOT_FOUND, "Exchange " + exchangeName + " does not exist.");
        }
        try {
            Map arguments = FieldTable.convertToMap((FieldTable)body.getArguments());
            String bindingKey = String.valueOf(routingKey);
            if (!exch.isBound(bindingKey, arguments, queue) && !exch.addBinding(bindingKey, queue, arguments) && "topic".equals(exch.getType())) {
                exch.replaceBinding(bindingKey, queue, arguments);
            }
        }
        catch (AccessControlException e) {
            throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, e.getMessage());
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding queue " + queue + " to exchange " + exch + " with routing key " + routingKey));
        }
        if (!body.getNowait()) {
            channel.sync();
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            QueueBindOkBody responseBody = methodRegistry.createQueueBindOkBody();
            protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
    }

    protected boolean isDefaultExchange(AMQShortString exchangeName) {
        return exchangeName == null || exchangeName.equals(AMQShortString.EMPTY_STRING);
    }
}

