/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import java.security.AccessControlException;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueueDeclareBody;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueArgumentsConverter;
import org.apache.qpid.server.virtualhost.QueueExistsException;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;

public class QueueDeclareHandler
implements StateAwareMethodListener<QueueDeclareBody> {
    private static final Logger _logger = Logger.getLogger(QueueDeclareHandler.class);
    private static final QueueDeclareHandler _instance = new QueueDeclareHandler();

    public static QueueDeclareHandler getInstance() {
        return _instance;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueDeclareBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        AMQChannel session = protocolConnection.getChannel(channelId);
        VirtualHostImpl<?, ?, ?> virtualHost = protocolConnection.getVirtualHost();
        AMQShortString queueName = body.getQueue() == null || body.getQueue().length() == 0 ? this.createName() : body.getQueue().intern();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (body.getPassive()) {
            queue = virtualHost.getQueue(queueName.toString());
            if (queue == null) {
                String msg = "Queue: " + queueName + " not found on VirtualHost(" + virtualHost + ").";
                throw body.getChannelException(AMQConstant.NOT_FOUND, msg);
            }
            if (!queue.verifySessionAccess(channel)) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getName() + " is exclusive, but not created on this Connection.");
            }
            channel.setDefaultQueue(queue);
        } else {
            try {
                queue = this.createQueue(channel, queueName, body, virtualHost, protocolConnection);
            }
            catch (QueueExistsException qe) {
                queue = qe.getExistingQueue();
                if (!queue.verifySessionAccess(channel)) {
                    throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getName() + " is exclusive, but not created on this Connection.");
                }
                if (queue.isExclusive() != body.getExclusive()) {
                    throw body.getChannelException(AMQConstant.ALREADY_EXISTS, "Cannot re-declare queue '" + queue.getName() + "' with different exclusivity (was: " + queue.isExclusive() + " requested " + body.getExclusive() + ")");
                }
                if (body.getAutoDelete() && queue.getLifetimePolicy() != LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS || !body.getAutoDelete() && queue.getLifetimePolicy() != (body.getExclusive() && !body.getDurable() ? LifetimePolicy.DELETE_ON_CONNECTION_CLOSE : LifetimePolicy.PERMANENT)) {
                    throw body.getChannelException(AMQConstant.ALREADY_EXISTS, "Cannot re-declare queue '" + queue.getName() + "' with different lifetime policy (was: " + queue.getLifetimePolicy() + " requested autodelete: " + body.getAutoDelete() + ")");
                }
                if (queue.isDurable() != body.getDurable()) {
                    throw body.getChannelException(AMQConstant.ALREADY_EXISTS, "Cannot re-declare queue '" + queue.getName() + "' with different durability (was: " + queue.isDurable() + " requested " + body.getDurable() + ")");
                }
            }
            catch (AccessControlException e) {
                throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, e.getMessage());
            }
            channel.setDefaultQueue(queue);
        }
        if (!body.getNowait()) {
            channel.sync();
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            QueueDeclareOkBody responseBody = methodRegistry.createQueueDeclareOkBody(queueName, (long)queue.getQueueDepthMessages(), (long)queue.getConsumerCount());
            protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
            _logger.info((Object)("Queue " + queueName + " declared successfully"));
        }
    }

    protected AMQShortString createName() {
        return new AMQShortString("tmp_" + UUID.randomUUID());
    }

    protected AMQQueue createQueue(AMQChannel channel, AMQShortString queueName, QueueDeclareBody body, VirtualHostImpl virtualHost, AMQProtocolSession session) throws AMQException, QueueExistsException {
        ExclusivityPolicy exclusivityPolicy;
        LifetimePolicy lifetimePolicy;
        boolean durable = body.getDurable();
        boolean autoDelete = body.getAutoDelete();
        boolean exclusive = body.getExclusive();
        Map attributes = QueueArgumentsConverter.convertWireArgsToModel((Map)FieldTable.convertToMap((FieldTable)body.getArguments()));
        String queueNameString = AMQShortString.toString((AMQShortString)queueName);
        attributes.put("name", queueNameString);
        attributes.put("id", UUID.randomUUID());
        attributes.put("durable", durable);
        if (exclusive) {
            lifetimePolicy = autoDelete ? LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS : (durable ? LifetimePolicy.PERMANENT : LifetimePolicy.DELETE_ON_CONNECTION_CLOSE);
            exclusivityPolicy = durable ? ExclusivityPolicy.CONTAINER : ExclusivityPolicy.CONNECTION;
        } else {
            lifetimePolicy = autoDelete ? LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS : LifetimePolicy.PERMANENT;
            exclusivityPolicy = ExclusivityPolicy.NONE;
        }
        attributes.put("exclusive", exclusivityPolicy);
        attributes.put("lifetimePolicy", lifetimePolicy);
        AMQQueue queue = virtualHost.createQueue(attributes);
        return queue;
    }
}

