/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import java.security.AccessControlException;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueueDeleteBody;
import org.apache.qpid.framing.QueueDeleteOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;

public class QueueDeleteHandler
implements StateAwareMethodListener<QueueDeleteBody> {
    private static final QueueDeleteHandler _instance = new QueueDeleteHandler();
    private final boolean _failIfNotFound;

    public static QueueDeleteHandler getInstance() {
        return _instance;
    }

    public QueueDeleteHandler() {
        this(true);
    }

    public QueueDeleteHandler(boolean failIfNotFound) {
        this._failIfNotFound = failIfNotFound;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueDeleteBody body, int channelId) throws AMQException {
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHostImpl<?, ?, ?> virtualHost = protocolConnection.getVirtualHost();
        DurableConfigurationStore store = virtualHost.getDurableConfigurationStore();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.sync();
        AMQQueue queue = body.getQueue() == null ? channel.getDefaultQueue() : virtualHost.getQueue(body.getQueue().toString());
        if (queue == null) {
            if (this._failIfNotFound) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
            }
        } else {
            if (body.getIfEmpty() && !queue.isEmpty()) {
                throw body.getChannelException(AMQConstant.IN_USE, "Queue: " + body.getQueue() + " is not empty.");
            }
            if (body.getIfUnused() && !queue.isUnused()) {
                throw body.getChannelException(AMQConstant.IN_USE, "Queue: " + body.getQueue() + " is still used.");
            }
            if (!queue.verifySessionAccess(channel)) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getName() + " is exclusive, but not created on this Connection.");
            }
            int purged = 0;
            try {
                purged = virtualHost.removeQueue(queue);
            }
            catch (AccessControlException e) {
                throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, e.getMessage());
            }
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            QueueDeleteOkBody responseBody = methodRegistry.createQueueDeleteOkBody((long)purged);
            protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
    }
}

