/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import java.security.AccessControlException;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.QueuePurgeOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;

public class QueuePurgeHandler
implements StateAwareMethodListener<QueuePurgeBody> {
    private static final QueuePurgeHandler _instance = new QueuePurgeHandler();
    private final boolean _failIfNotFound;

    public static QueuePurgeHandler getInstance() {
        return _instance;
    }

    public QueuePurgeHandler() {
        this(true);
    }

    public QueuePurgeHandler(boolean failIfNotFound) {
        this._failIfNotFound = failIfNotFound;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueuePurgeBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHostImpl<?, ?, ?> virtualHost = protocolConnection.getVirtualHost();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        if (body.getQueue() == null) {
            queue = channel.getDefaultQueue();
            if (queue == null && this._failIfNotFound) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "No queue specified.");
            }
        } else {
            queue = virtualHost.getQueue(body.getQueue().toString());
        }
        if (queue == null) {
            if (this._failIfNotFound) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
            }
        } else {
            if (!queue.verifySessionAccess(channel)) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue is exclusive, but not created on this Connection.");
            }
            long purged = 0L;
            try {
                purged = queue.clearQueue();
            }
            catch (AccessControlException e) {
                throw body.getConnectionException(AMQConstant.ACCESS_REFUSED, e.getMessage());
            }
            if (!body.getNowait()) {
                channel.sync();
                MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
                QueuePurgeOkBody responseBody = methodRegistry.createQueuePurgeOkBody(purged);
                protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
            }
        }
    }
}

