/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.TxCommitBody;
import org.apache.qpid.framing.TxCommitOkBody;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;

public class TxCommitHandler
implements StateAwareMethodListener<TxCommitBody> {
    private static final Logger _log = Logger.getLogger(TxCommitHandler.class);
    private static TxCommitHandler _instance = new TxCommitHandler();

    public static TxCommitHandler getInstance() {
        return _instance;
    }

    private TxCommitHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, TxCommitBody body, final int channelId) throws AMQException {
        final AMQProtocolSession session = stateManager.getProtocolSession();
        try {
            AMQChannel channel;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Commit received on channel " + channelId));
            }
            if ((channel = session.getChannel(channelId)) == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            channel.commit(new Runnable(){

                @Override
                public void run() {
                    MethodRegistry methodRegistry = session.getMethodRegistry();
                    TxCommitOkBody responseBody = methodRegistry.createTxCommitOkBody();
                    session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
                }
            }, true);
        }
        catch (AMQException e) {
            throw body.getChannelException(e.getErrorCode(), "Failed to commit: " + e.getMessage());
        }
    }
}

