/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.handler;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.TxSelectBody;
import org.apache.qpid.framing.TxSelectOkBody;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQStateManager;
import org.apache.qpid.server.protocol.v0_8.state.StateAwareMethodListener;

public class TxSelectHandler
implements StateAwareMethodListener<TxSelectBody> {
    private static TxSelectHandler _instance = new TxSelectHandler();

    public static TxSelectHandler getInstance() {
        return _instance;
    }

    private TxSelectHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, TxSelectBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.setLocalTransactional();
        MethodRegistry methodRegistry = session.getMethodRegistry();
        TxSelectOkBody responseBody = methodRegistry.createTxSelectOkBody();
        session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
    }
}

