/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.state;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.protocol.AMQMethodEvent;
import org.apache.qpid.protocol.AMQMethodListener;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.protocol.v0_8.AMQChannel;
import org.apache.qpid.server.protocol.v0_8.AMQProtocolSession;
import org.apache.qpid.server.protocol.v0_8.state.AMQState;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class AMQStateManager
implements AMQMethodListener {
    private static final Logger _logger = Logger.getLogger(AMQStateManager.class);
    private final Broker<?> _broker;
    private final AMQProtocolSession _protocolSession;
    private AMQState _currentState;

    public AMQStateManager(Broker<?> broker, AMQProtocolSession protocolSession) {
        this._broker = broker;
        this._protocolSession = protocolSession;
        this._currentState = AMQState.CONNECTION_NOT_STARTED;
    }

    public Broker<?> getBroker() {
        return this._broker;
    }

    public void changeState(AMQState newState) {
        _logger.debug((Object)("State changing to " + (Object)((Object)newState) + " from old state " + (Object)((Object)this._currentState)));
        AMQState oldState = this._currentState;
        this._currentState = newState;
    }

    public void error(Exception e) {
        _logger.error((Object)("State manager received error notification[Current State:" + (Object)((Object)this._currentState) + "]: " + e), (Throwable)e);
    }

    public <B extends AMQMethodBody> boolean methodReceived(AMQMethodEvent<B> evt) throws AMQException {
        final MethodDispatcher dispatcher = this._protocolSession.getMethodDispatcher();
        final int channelId = evt.getChannelId();
        final AMQMethodBody body = evt.getMethod();
        AMQChannel channel = this._protocolSession.getChannel(channelId);
        if (!(channelId == 0 || channel != null || body instanceof ChannelOpenBody || body instanceof ChannelCloseOkBody || body instanceof ChannelCloseBody)) {
            throw body.getConnectionException(AMQConstant.CHANNEL_ERROR, "channel is closed won't process:" + body);
        }
        if (channel == null) {
            return body.execute(dispatcher, channelId);
        }
        try {
            return Subject.doAs(channel.getSubject(), new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws AMQException {
                    return body.execute(dispatcher, channelId);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof AMQException) {
                throw (AMQException)e.getCause();
            }
            throw new ServerScopedRuntimeException(e.getCause());
        }
    }

    public AMQProtocolSession getProtocolSession() {
        return this._protocolSession;
    }

    public SubjectCreator getSubjectCreator() {
        return this._broker.getSubjectCreator(this.getProtocolSession().getLocalAddress(), this.getProtocolSession().getTransport().isSecure());
    }
}

