/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.MessagePublishInfo;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.store.StoredMessage;

public class AMQMessage
extends AbstractServerMessageImpl<AMQMessage, MessageMetaData> {
    private static final MessageMetaData DELETED_MESSAGE_METADATA = new MessageMetaData(new MessagePublishInfo(), new ContentHeaderBody(new BasicContentHeaderProperties()), 0L);
    private final long _size;

    public AMQMessage(StoredMessage<MessageMetaData> handle) {
        this(handle, null);
    }

    public AMQMessage(StoredMessage<MessageMetaData> handle, Object connectionReference) {
        super(handle, connectionReference);
        this._size = ((MessageMetaData)handle.getMetaData()).getContentSize();
    }

    public MessageMetaData getMessageMetaData() {
        MessageMetaData metaData = (MessageMetaData)this.getStoredMessage().getMetaData();
        return metaData == null ? DELETED_MESSAGE_METADATA : metaData;
    }

    public ContentHeaderBody getContentHeaderBody() {
        return this.getMessageMetaData().getContentHeaderBody();
    }

    public String getInitialRoutingAddress() {
        AMQShortString routingKey;
        MessageMetaData messageMetaData = this.getMessageMetaData();
        if (messageMetaData != null && (routingKey = messageMetaData.getMessagePublishInfo().getRoutingKey()) != null) {
            return routingKey.toString();
        }
        return null;
    }

    public AMQMessageHeader getMessageHeader() {
        return this.getMessageMetaData().getMessageHeader();
    }

    public MessagePublishInfo getMessagePublishInfo() {
        return this.getMessageMetaData().getMessagePublishInfo();
    }

    public long getArrivalTime() {
        return this.getMessageMetaData().getArrivalTime();
    }

    public long getSize() {
        return this._size;
    }

    public boolean isImmediate() {
        return this.getMessagePublishInfo().isImmediate();
    }

    public boolean isMandatory() {
        return this.getMessagePublishInfo().isMandatory();
    }

    public long getExpiration() {
        return this.getMessageHeader().getExpiration();
    }
}

