/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.util.Map;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.protocol.v0_8.UnacknowledgedMessageMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractResendAndRequeue
implements UnacknowledgedMessageMap.Visitor {
    private static final Logger _log = LoggerFactory.getLogger(ExtractResendAndRequeue.class);
    private final Map<Long, MessageInstance> _msgToRequeue;
    private final Map<Long, MessageInstance> _msgToResend;
    private final UnacknowledgedMessageMap _unacknowledgedMessageMap;

    public ExtractResendAndRequeue(UnacknowledgedMessageMap unacknowledgedMessageMap, Map<Long, MessageInstance> msgToRequeue, Map<Long, MessageInstance> msgToResend) {
        this._unacknowledgedMessageMap = unacknowledgedMessageMap;
        this._msgToRequeue = msgToRequeue;
        this._msgToResend = msgToResend;
    }

    @Override
    public boolean callback(long deliveryTag, MessageInstance message) {
        message.setRedelivered();
        ConsumerImpl consumer = message.getDeliveredConsumer();
        if (consumer != null) {
            if (!consumer.isClosed()) {
                this._msgToResend.put(deliveryTag, message);
            } else {
                this._msgToRequeue.put(deliveryTag, message);
            }
        }
        return false;
    }

    @Override
    public void visitComplete() {
        this._unacknowledgedMessageMap.clear();
    }
}

