/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.io.IOException;
import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageContentSource;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQPConnection_0_8Impl;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.ProtocolOutputConverter;
import org.apache.qpid.server.protocol.v0_8.transport.AMQBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.AMQFrame;
import org.apache.qpid.server.protocol.v0_8.transport.AMQVersionAwareProtocolSession;
import org.apache.qpid.server.protocol.v0_8.transport.BasicCancelOkBody;
import org.apache.qpid.server.protocol.v0_8.transport.BasicContentHeaderProperties;
import org.apache.qpid.server.protocol.v0_8.transport.ContentHeaderBody;
import org.apache.qpid.server.protocol.v0_8.transport.MessagePublishInfo;
import org.apache.qpid.server.transport.ByteBufferSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolOutputConverterImpl
implements ProtocolOutputConverter {
    private static final int BASIC_CLASS_ID = 60;
    private final AMQPConnection_0_8Impl _connection;
    private static final AMQShortString GZIP_ENCODING = AMQShortString.valueOf((String)"gzip");
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolOutputConverterImpl.class);

    public ProtocolOutputConverterImpl(AMQPConnection_0_8Impl connection) {
        this._connection = connection;
    }

    @Override
    public long writeDeliver(AMQMessage msg, InstanceProperties props, int channelId, long deliveryTag, AMQShortString consumerTag) {
        boolean isRedelivered = Boolean.TRUE.equals(props.getProperty(InstanceProperties.Property.REDELIVERED));
        AMQBody deliverBody = this.createEncodedDeliverBody(msg, isRedelivered, deliveryTag, consumerTag);
        return this.writeMessageDelivery(msg, channelId, deliverBody);
    }

    private long writeMessageDelivery(AMQMessage message, int channelId, AMQBody deliverBody) {
        return this.writeMessageDelivery((MessageContentSource)message, message.getContentHeaderBody(), channelId, deliverBody);
    }

    private long writeMessageDelivery(MessageContentSource message, ContentHeaderBody contentHeaderBody, int channelId, AMQBody deliverBody) {
        long length;
        int bodySize = (int)message.getSize();
        boolean msgCompressed = this.isCompressed(contentHeaderBody);
        DisposableMessageContentSource modifiedContent = null;
        boolean compressionSupported = this._connection.isCompressionSupported();
        if (msgCompressed && !compressionSupported && (modifiedContent = this.inflateIfPossible(message)) != null) {
            BasicContentHeaderProperties modifiedProps = new BasicContentHeaderProperties(contentHeaderBody.getProperties());
            modifiedProps.setEncoding((String)null);
            length = this.writeMessageDeliveryModified(modifiedContent, channelId, deliverBody, modifiedProps);
        } else if (!msgCompressed && compressionSupported && contentHeaderBody.getProperties().getEncoding() == null && bodySize > this._connection.getMessageCompressionThreshold() && (modifiedContent = this.deflateIfPossible(message)) != null) {
            BasicContentHeaderProperties modifiedProps = new BasicContentHeaderProperties(contentHeaderBody.getProperties());
            modifiedProps.setEncoding(GZIP_ENCODING);
            length = this.writeMessageDeliveryModified(modifiedContent, channelId, deliverBody, modifiedProps);
        } else {
            this.writeMessageDeliveryUnchanged(message, channelId, deliverBody, contentHeaderBody, bodySize);
            length = bodySize;
        }
        if (modifiedContent != null) {
            modifiedContent.dispose();
        }
        return length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DisposableMessageContentSource deflateIfPossible(MessageContentSource source) {
        try (QpidByteBuffer contentBuffers = source.getContent();){
            ModifiedContentSource modifiedContentSource = new ModifiedContentSource(QpidByteBuffer.deflate((QpidByteBuffer)contentBuffers));
            return modifiedContentSource;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to compress message payload for consumer with gzip, message will be sent as is", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DisposableMessageContentSource inflateIfPossible(MessageContentSource source) {
        try (QpidByteBuffer contentBuffers = source.getContent();){
            ModifiedContentSource modifiedContentSource = new ModifiedContentSource(QpidByteBuffer.inflate((QpidByteBuffer)contentBuffers));
            return modifiedContentSource;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to decompress message payload for consumer with gzip, message will be sent as is", (Throwable)e);
            return null;
        }
    }

    private int writeMessageDeliveryModified(MessageContentSource content, int channelId, AMQBody deliverBody, BasicContentHeaderProperties modifiedProps) {
        int bodySize = (int)content.getSize();
        ContentHeaderBody modifiedHeaderBody = new ContentHeaderBody(modifiedProps, (long)bodySize);
        this.writeMessageDeliveryUnchanged(content, channelId, deliverBody, modifiedHeaderBody, bodySize);
        return bodySize;
    }

    private void writeMessageDeliveryUnchanged(MessageContentSource content, int channelId, AMQBody deliverBody, ContentHeaderBody contentHeaderBody, int bodySize) {
        if (bodySize == 0) {
            SmallCompositeAMQBodyBlock compositeBlock = new SmallCompositeAMQBodyBlock(channelId, deliverBody, contentHeaderBody);
            this.writeFrame(compositeBlock);
        } else {
            int capacity;
            MessageContentSourceBody firstContentBody = new MessageContentSourceBody(content, 0, capacity);
            CompositeAMQBodyBlock compositeBlock = new CompositeAMQBodyBlock(channelId, deliverBody, contentHeaderBody, firstContentBody);
            this.writeFrame(compositeBlock);
            for (int writtenSize = capacity = bodySize > (maxBodySize = (int)this._connection.getMaxFrameSize() - AMQFrame.getFrameOverhead()) ? maxBodySize : bodySize; writtenSize < bodySize; writtenSize += capacity) {
                int maxBodySize;
                capacity = bodySize - writtenSize > maxBodySize ? maxBodySize : bodySize - writtenSize;
                MessageContentSourceBody body = new MessageContentSourceBody(content, writtenSize, capacity);
                this.writeFrame(new AMQFrame(channelId, body));
            }
        }
    }

    private boolean isCompressed(ContentHeaderBody contentHeaderBody) {
        return GZIP_ENCODING.equals(contentHeaderBody.getProperties().getEncoding());
    }

    @Override
    public long writeGetOk(AMQMessage amqMessage, InstanceProperties props, int channelId, long deliveryTag, int queueSize) {
        AMQBody deliver = this.createEncodedGetOkBody(amqMessage, props, deliveryTag, queueSize);
        return this.writeMessageDelivery(amqMessage, channelId, deliver);
    }

    private AMQBody createEncodedDeliverBody(AMQMessage message, boolean isRedelivered, long deliveryTag, AMQShortString consumerTag) {
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQShortString exchangeName = pb.getExchange();
        AMQShortString routingKey = pb.getRoutingKey();
        return new EncodedDeliveryBody(deliveryTag, routingKey, exchangeName, consumerTag, isRedelivered);
    }

    private AMQBody createEncodedGetOkBody(AMQMessage message, InstanceProperties props, long deliveryTag, int queueSize) {
        MessagePublishInfo pb = message.getMessagePublishInfo();
        AMQShortString exchangeName = pb.getExchange();
        AMQShortString routingKey = pb.getRoutingKey();
        boolean isRedelivered = Boolean.TRUE.equals(props.getProperty(InstanceProperties.Property.REDELIVERED));
        return this._connection.getMethodRegistry().createBasicGetOkBody(deliveryTag, isRedelivered, exchangeName, routingKey, queueSize);
    }

    private AMQBody createEncodedReturnFrame(MessagePublishInfo messagePublishInfo, int replyCode, AMQShortString replyText) {
        return this._connection.getMethodRegistry().createBasicReturnBody(replyCode, replyText, messagePublishInfo.getExchange(), messagePublishInfo.getRoutingKey());
    }

    @Override
    public void writeReturn(MessagePublishInfo messagePublishInfo, ContentHeaderBody header, MessageContentSource message, int channelId, int replyCode, AMQShortString replyText) {
        AMQBody returnFrame = this.createEncodedReturnFrame(messagePublishInfo, replyCode, replyText);
        this.writeMessageDelivery(message, header, channelId, returnFrame);
    }

    @Override
    public void writeFrame(AMQDataBlock block) {
        this._connection.writeFrame(block);
    }

    @Override
    public void confirmConsumerAutoClose(int channelId, AMQShortString consumerTag) {
        BasicCancelOkBody basicCancelOkBody = this._connection.getMethodRegistry().createBasicCancelOkBody(consumerTag);
        this.writeFrame(basicCancelOkBody.generateFrame(channelId));
    }

    private static class ModifiedContentSource
    implements DisposableMessageContentSource {
        private final QpidByteBuffer _buffer;
        private final int _size;

        public ModifiedContentSource(QpidByteBuffer buffer) {
            this._buffer = buffer;
            this._size = this._buffer.remaining();
        }

        @Override
        public void dispose() {
            this._buffer.dispose();
        }

        public QpidByteBuffer getContent() {
            return this.getContent(0, (int)this.getSize());
        }

        public QpidByteBuffer getContent(int offset, int length) {
            return this._buffer.view(offset, length);
        }

        public long getSize() {
            return this._size;
        }
    }

    public static final class SmallCompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 2 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final int _channel;

        public SmallCompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
        }

        @Override
        public long getSize() {
            return (long)OVERHEAD + (long)this._methodBody.getSize() + (long)this._headerBody.getSize();
        }

        @Override
        public long writePayload(ByteBufferSender sender) {
            long size = new AMQFrame(this._channel, this._methodBody).writePayload(sender);
            return size += new AMQFrame(this._channel, this._headerBody).writePayload(sender);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName()).append("methodBody=").append(this._methodBody).append(", headerBody=").append(this._headerBody).append(", channel=").append(this._channel).append("]");
            return builder.toString();
        }
    }

    public static final class CompositeAMQBodyBlock
    extends AMQDataBlock {
        public static final int OVERHEAD = 3 * AMQFrame.getFrameOverhead();
        private final AMQBody _methodBody;
        private final AMQBody _headerBody;
        private final AMQBody _contentBody;
        private final int _channel;

        public CompositeAMQBodyBlock(int channel, AMQBody methodBody, AMQBody headerBody, AMQBody contentBody) {
            this._channel = channel;
            this._methodBody = methodBody;
            this._headerBody = headerBody;
            this._contentBody = contentBody;
        }

        @Override
        public long getSize() {
            return (long)OVERHEAD + (long)this._methodBody.getSize() + (long)this._headerBody.getSize() + (long)this._contentBody.getSize();
        }

        @Override
        public long writePayload(ByteBufferSender sender) {
            long size = new AMQFrame(this._channel, this._methodBody).writePayload(sender);
            size += new AMQFrame(this._channel, this._headerBody).writePayload(sender);
            return size += new AMQFrame(this._channel, this._contentBody).writePayload(sender);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[").append(this.getClass().getSimpleName()).append(" methodBody=").append(this._methodBody).append(", headerBody=").append(this._headerBody).append(", contentBody=").append(this._contentBody).append(", channel=").append(this._channel).append("]");
            return builder.toString();
        }
    }

    private class EncodedDeliveryBody
    implements AMQBody {
        private final long _deliveryTag;
        private final AMQShortString _routingKey;
        private final AMQShortString _exchangeName;
        private final AMQShortString _consumerTag;
        private final boolean _isRedelivered;
        private AMQBody _underlyingBody;

        private EncodedDeliveryBody(long deliveryTag, AMQShortString routingKey, AMQShortString exchangeName, AMQShortString consumerTag, boolean isRedelivered) {
            this._deliveryTag = deliveryTag;
            this._routingKey = routingKey;
            this._exchangeName = exchangeName;
            this._consumerTag = consumerTag;
            this._isRedelivered = isRedelivered;
        }

        public AMQBody createAMQBody() {
            return ProtocolOutputConverterImpl.this._connection.getMethodRegistry().createBasicDeliverBody(this._consumerTag, this._deliveryTag, this._isRedelivered, this._exchangeName, this._routingKey);
        }

        @Override
        public byte getFrameType() {
            return 1;
        }

        @Override
        public int getSize() {
            if (this._underlyingBody == null) {
                this._underlyingBody = this.createAMQBody();
            }
            return this._underlyingBody.getSize();
        }

        @Override
        public long writePayload(ByteBufferSender sender) {
            if (this._underlyingBody == null) {
                this._underlyingBody = this.createAMQBody();
            }
            return this._underlyingBody.writePayload(sender);
        }

        @Override
        public void handle(int channelId, AMQVersionAwareProtocolSession amqProtocolSession) throws QpidException {
            throw new QpidException("This block should never be dispatched!");
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " underlyingBody: " + String.valueOf(this._underlyingBody) + "]";
        }
    }

    private class MessageContentSourceBody
    implements AMQBody {
        public static final byte TYPE = 3;
        private final int _length;
        private final MessageContentSource _content;
        private final int _offset;

        public MessageContentSourceBody(MessageContentSource content, int offset, int length) {
            this._content = content;
            this._offset = offset;
            this._length = length;
        }

        @Override
        public byte getFrameType() {
            return 3;
        }

        @Override
        public int getSize() {
            return this._length;
        }

        @Override
        public long writePayload(ByteBufferSender sender) {
            long size;
            try (QpidByteBuffer content = this._content.getContent(this._offset, this._length);){
                size = content.remaining();
                sender.send(content);
            }
            return size;
        }

        @Override
        public void handle(int channelId, AMQVersionAwareProtocolSession amqProtocolSession) throws QpidException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + " offset: " + this._offset + ", length: " + this._length + "]";
        }
    }

    static interface DisposableMessageContentSource
    extends MessageContentSource {
        public void dispose();
    }
}

