/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import java.util.Map;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.FieldTableFactory;
import org.apache.qpid.server.transport.ByteBufferSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicContentHeaderProperties {
    public static final byte NON_PERSISTENT = 1;
    public static final byte PERSISTENT = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicContentHeaderProperties.class);
    private static final AMQShortString ZERO_STRING = null;
    private AMQShortString _contentType;
    private AMQShortString _encoding;
    private FieldTable _headers = FieldTable.EMPTY;
    private byte _deliveryMode;
    private byte _priority;
    private AMQShortString _correlationId;
    private AMQShortString _replyTo;
    private long _expiration;
    private AMQShortString _messageId;
    private long _timestamp;
    private AMQShortString _type;
    private AMQShortString _userId;
    private AMQShortString _appId;
    private AMQShortString _clusterId;
    private int _propertyFlags = 0;
    private static final int CONTENT_TYPE_MASK = 32768;
    private static final int ENCODING_MASK = 16384;
    private static final int HEADERS_MASK = 8192;
    private static final int DELIVERY_MODE_MASK = 4096;
    private static final int PRIORITY_MASK = 2048;
    private static final int CORRELATION_ID_MASK = 1024;
    private static final int REPLY_TO_MASK = 512;
    private static final int EXPIRATION_MASK = 256;
    private static final int MESSAGE_ID_MASK = 128;
    private static final int TIMESTAMP_MASK = 64;
    private static final int TYPE_MASK = 32;
    private static final int USER_ID_MASK = 16;
    private static final int APPLICATION_ID_MASK = 8;
    private static final int CLUSTER_ID_MASK = 4;
    private QpidByteBuffer _encodedForm;

    public BasicContentHeaderProperties(BasicContentHeaderProperties other) {
        this._headers = FieldTableFactory.createFieldTable((Map)FieldTable.convertToMap((FieldTable)other.getHeaders()));
        this._contentType = other._contentType;
        this._encoding = other._encoding;
        this._deliveryMode = other._deliveryMode;
        this._priority = other._priority;
        this._correlationId = other._correlationId;
        this._replyTo = other._replyTo;
        this._expiration = other._expiration;
        this._messageId = other._messageId;
        this._timestamp = other._timestamp;
        this._type = other._type;
        this._userId = other._userId;
        this._appId = other._appId;
        this._clusterId = other._clusterId;
        this._propertyFlags = other._propertyFlags;
    }

    public BasicContentHeaderProperties() {
    }

    public synchronized int getPropertyListSize() {
        if (this.useEncodedForm()) {
            return this._encodedForm.remaining();
        }
        int size = 0;
        if ((this._propertyFlags & 0x8000) != 0) {
            size += EncodingUtils.encodedShortStringLength((AMQShortString)this._contentType);
        }
        if ((this._propertyFlags & 0x4000) != 0) {
            size += EncodingUtils.encodedShortStringLength((AMQShortString)this._encoding);
        }
        if ((this._propertyFlags & 0x2000) != 0) {
            size += EncodingUtils.encodedFieldTableLength((FieldTable)this._headers);
        }
        if ((this._propertyFlags & 0x1000) != 0) {
            ++size;
        }
        if ((this._propertyFlags & 0x800) != 0) {
            ++size;
        }
        if ((this._propertyFlags & 0x400) != 0) {
            size += EncodingUtils.encodedShortStringLength((AMQShortString)this._correlationId);
        }
        if ((this._propertyFlags & 0x200) != 0) {
            size += EncodingUtils.encodedShortStringLength((AMQShortString)this._replyTo);
        }
        if ((this._propertyFlags & 0x100) != 0) {
            size = this._expiration == 0L ? (size += EncodingUtils.encodedShortStringLength((AMQShortString)ZERO_STRING)) : (size += EncodingUtils.encodedShortStringLength((long)this._expiration));
        }
        if ((this._propertyFlags & 0x80) != 0) {
            size += EncodingUtils.encodedShortStringLength((AMQShortString)this._messageId);
        }
        if ((this._propertyFlags & 0x40) != 0) {
            size += 8;
        }
        if ((this._propertyFlags & 0x20) != 0) {
            size += EncodingUtils.encodedShortStringLength((AMQShortString)this._type);
        }
        if ((this._propertyFlags & 0x10) != 0) {
            size += EncodingUtils.encodedShortStringLength((AMQShortString)this._userId);
        }
        if ((this._propertyFlags & 8) != 0) {
            size += EncodingUtils.encodedShortStringLength((AMQShortString)this._appId);
        }
        if ((this._propertyFlags & 4) != 0) {
            size += EncodingUtils.encodedShortStringLength((AMQShortString)this._clusterId);
        }
        return size;
    }

    public void setPropertyFlags(int propertyFlags) {
        this._propertyFlags = propertyFlags;
    }

    public int getPropertyFlags() {
        return this._propertyFlags;
    }

    public synchronized long writePropertyListPayload(QpidByteBuffer buffer) {
        if (this.useEncodedForm()) {
            buffer.putCopyOf(this._encodedForm);
            return this._encodedForm.remaining();
        }
        int propertyListSize = this.getPropertyListSize();
        if ((this._propertyFlags & 0x8000) != 0) {
            EncodingUtils.writeShortStringBytes((QpidByteBuffer)buffer, (AMQShortString)this._contentType);
        }
        if ((this._propertyFlags & 0x4000) != 0) {
            EncodingUtils.writeShortStringBytes((QpidByteBuffer)buffer, (AMQShortString)this._encoding);
        }
        if ((this._propertyFlags & 0x2000) != 0) {
            EncodingUtils.writeFieldTableBytes((QpidByteBuffer)buffer, (FieldTable)this._headers);
        }
        if ((this._propertyFlags & 0x1000) != 0) {
            buffer.put(this._deliveryMode);
        }
        if ((this._propertyFlags & 0x800) != 0) {
            buffer.put(this._priority);
        }
        if ((this._propertyFlags & 0x400) != 0) {
            EncodingUtils.writeShortStringBytes((QpidByteBuffer)buffer, (AMQShortString)this._correlationId);
        }
        if ((this._propertyFlags & 0x200) != 0) {
            EncodingUtils.writeShortStringBytes((QpidByteBuffer)buffer, (AMQShortString)this._replyTo);
        }
        if ((this._propertyFlags & 0x100) != 0) {
            if (this._expiration == 0L) {
                EncodingUtils.writeShortStringBytes((QpidByteBuffer)buffer, (AMQShortString)ZERO_STRING);
            } else {
                EncodingUtils.writeLongAsShortString((QpidByteBuffer)buffer, (long)this._expiration);
            }
        }
        if ((this._propertyFlags & 0x80) != 0) {
            EncodingUtils.writeShortStringBytes((QpidByteBuffer)buffer, (AMQShortString)this._messageId);
        }
        if ((this._propertyFlags & 0x40) != 0) {
            buffer.putLong(this._timestamp);
        }
        if ((this._propertyFlags & 0x20) != 0) {
            EncodingUtils.writeShortStringBytes((QpidByteBuffer)buffer, (AMQShortString)this._type);
        }
        if ((this._propertyFlags & 0x10) != 0) {
            EncodingUtils.writeShortStringBytes((QpidByteBuffer)buffer, (AMQShortString)this._userId);
        }
        if ((this._propertyFlags & 8) != 0) {
            EncodingUtils.writeShortStringBytes((QpidByteBuffer)buffer, (AMQShortString)this._appId);
        }
        if ((this._propertyFlags & 4) != 0) {
            EncodingUtils.writeShortStringBytes((QpidByteBuffer)buffer, (AMQShortString)this._clusterId);
        }
        return propertyListSize;
    }

    public synchronized long writePropertyListPayload(ByteBufferSender sender) {
        if (this.useEncodedForm()) {
            try (QpidByteBuffer duplicate = this._encodedForm.duplicate();){
                sender.send(duplicate);
            }
            return this._encodedForm.remaining();
        }
        int propertyListSize = this.getPropertyListSize();
        try (QpidByteBuffer buf = QpidByteBuffer.allocate((boolean)sender.isDirectBufferPreferred(), (int)propertyListSize);){
            this.writePropertyListPayload(buf);
            buf.flip();
            sender.send(buf);
        }
        return propertyListSize;
    }

    public BasicContentHeaderProperties(QpidByteBuffer buffer, int propertyFlags, int size) throws AMQFrameDecodingException {
        this._propertyFlags = propertyFlags;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Property flags: " + this._propertyFlags);
        }
        if (this._encodedForm != null) {
            this._encodedForm.dispose();
        }
        this._encodedForm = buffer.view(0, size);
        try (QpidByteBuffer byteBuffer = this._encodedForm.slice();){
            this.decode(byteBuffer);
        }
        buffer.position(buffer.position() + size);
    }

    private void decode(QpidByteBuffer buffer) throws AMQFrameDecodingException {
        if ((this._propertyFlags & 0x8000) != 0) {
            this._contentType = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        }
        if ((this._propertyFlags & 0x4000) != 0) {
            this._encoding = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        }
        if ((this._propertyFlags & 0x2000) != 0) {
            long length = buffer.getUnsignedInt();
            try (QpidByteBuffer buf = buffer.view(0, (int)length);){
                this._headers = FieldTableFactory.createFieldTable((QpidByteBuffer)buf);
            }
            buffer.position(buffer.position() + (int)length);
        }
        if ((this._propertyFlags & 0x1000) != 0) {
            this._deliveryMode = buffer.get();
        }
        if ((this._propertyFlags & 0x800) != 0) {
            this._priority = buffer.get();
        }
        if ((this._propertyFlags & 0x400) != 0) {
            this._correlationId = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        }
        if ((this._propertyFlags & 0x200) != 0) {
            this._replyTo = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        }
        if ((this._propertyFlags & 0x100) != 0) {
            this._expiration = EncodingUtils.readLongAsShortString((QpidByteBuffer)buffer);
        }
        if ((this._propertyFlags & 0x80) != 0) {
            this._messageId = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        }
        if ((this._propertyFlags & 0x40) != 0) {
            this._timestamp = buffer.getLong();
        }
        if ((this._propertyFlags & 0x20) != 0) {
            this._type = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        }
        if ((this._propertyFlags & 0x10) != 0) {
            this._userId = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        }
        if ((this._propertyFlags & 8) != 0) {
            this._appId = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        }
        if ((this._propertyFlags & 4) != 0) {
            this._clusterId = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        }
    }

    public AMQShortString getContentType() {
        return this._contentType;
    }

    public String getContentTypeAsString() {
        return this._contentType == null ? null : this._contentType.toString();
    }

    public synchronized void setContentType(AMQShortString contentType) {
        this._propertyFlags = contentType == null ? (this._propertyFlags &= 0xFFFF7FFF) : (this._propertyFlags |= 0x8000);
        this._contentType = contentType;
        this.nullEncodedForm();
    }

    public void setContentType(String contentType) {
        this.setContentType(contentType == null ? null : AMQShortString.valueOf((String)contentType));
    }

    public String getEncodingAsString() {
        return this.getEncoding() == null ? null : this.getEncoding().toString();
    }

    public AMQShortString getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this.setEncoding(encoding == null ? null : AMQShortString.valueOf((String)encoding));
    }

    public synchronized void setEncoding(AMQShortString encoding) {
        this._propertyFlags = encoding == null ? (this._propertyFlags &= 0xFFFFBFFF) : (this._propertyFlags |= 0x4000);
        this._encoding = encoding;
        this.nullEncodedForm();
    }

    public FieldTable getHeaders() {
        return this._headers;
    }

    public synchronized void setHeaders(FieldTable headers) {
        this._propertyFlags = headers == null ? (this._propertyFlags &= 0xFFFFDFFF) : (this._propertyFlags |= 0x2000);
        this._headers = headers == null ? FieldTable.EMPTY : headers;
        this.nullEncodedForm();
    }

    public byte getDeliveryMode() {
        return this._deliveryMode;
    }

    public synchronized void setDeliveryMode(byte deliveryMode) {
        this._propertyFlags |= 0x1000;
        this._deliveryMode = deliveryMode;
        this.nullEncodedForm();
    }

    public byte getPriority() {
        return this._priority;
    }

    public synchronized void setPriority(byte priority) {
        this._propertyFlags |= 0x800;
        this._priority = priority;
        this.nullEncodedForm();
    }

    public AMQShortString getCorrelationId() {
        return this._correlationId;
    }

    public String getCorrelationIdAsString() {
        return this._correlationId == null ? null : this._correlationId.toString();
    }

    public void setCorrelationId(String correlationId) {
        this.setCorrelationId(correlationId == null ? null : AMQShortString.valueOf((String)correlationId));
    }

    public synchronized void setCorrelationId(AMQShortString correlationId) {
        this._propertyFlags = correlationId == null ? (this._propertyFlags &= 0xFFFFFBFF) : (this._propertyFlags |= 0x400);
        this._correlationId = correlationId;
        this.nullEncodedForm();
    }

    public String getReplyToAsString() {
        return this._replyTo == null ? null : this._replyTo.toString();
    }

    public AMQShortString getReplyTo() {
        return this._replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.setReplyTo(replyTo == null ? null : AMQShortString.valueOf((String)replyTo));
    }

    public synchronized void setReplyTo(AMQShortString replyTo) {
        this._propertyFlags = replyTo == null ? (this._propertyFlags &= 0xFFFFFDFF) : (this._propertyFlags |= 0x200);
        this._replyTo = replyTo;
        this.nullEncodedForm();
    }

    public long getExpiration() {
        return this._expiration;
    }

    public synchronized void setExpiration(long expiration) {
        this._propertyFlags = expiration == 0L ? (this._propertyFlags &= 0xFFFFFEFF) : (this._propertyFlags |= 0x100);
        this._expiration = expiration;
        this.nullEncodedForm();
    }

    public boolean hasExpiration() {
        return (this._propertyFlags & 0x100) != 0;
    }

    public AMQShortString getMessageId() {
        return this._messageId;
    }

    public String getMessageIdAsString() {
        return this._messageId == null ? null : this._messageId.toString();
    }

    public void setMessageId(String messageId) {
        this.setMessageId(messageId == null ? null : AMQShortString.createAMQShortString((String)messageId));
    }

    public synchronized void setMessageId(AMQShortString messageId) {
        this._propertyFlags = messageId == null ? (this._propertyFlags &= 0xFFFFFF7F) : (this._propertyFlags |= 0x80);
        this._messageId = messageId;
        this.nullEncodedForm();
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public synchronized void setTimestamp(long timestamp) {
        this._propertyFlags |= 0x40;
        this._timestamp = timestamp;
        this.nullEncodedForm();
    }

    public boolean hasTimestamp() {
        return (this._propertyFlags & 0x40) != 0;
    }

    public String getTypeAsString() {
        return this._type == null ? null : this._type.toString();
    }

    public AMQShortString getType() {
        return this._type;
    }

    public void setType(String type) {
        this.setType(type == null ? null : AMQShortString.valueOf((String)type));
    }

    public synchronized void setType(AMQShortString type) {
        this._propertyFlags = type == null ? (this._propertyFlags &= 0xFFFFFFDF) : (this._propertyFlags |= 0x20);
        this._type = type;
        this.nullEncodedForm();
    }

    public String getUserIdAsString() {
        return this._userId == null ? null : this._userId.toString();
    }

    public AMQShortString getUserId() {
        return this._userId;
    }

    public void setUserId(String userId) {
        this.setUserId(userId == null ? null : AMQShortString.valueOf((String)userId));
    }

    public synchronized void setUserId(AMQShortString userId) {
        this._propertyFlags = userId == null ? (this._propertyFlags &= 0xFFFFFFEF) : (this._propertyFlags |= 0x10);
        this._userId = userId;
        this.nullEncodedForm();
    }

    public String getAppIdAsString() {
        return this._appId == null ? null : this._appId.toString();
    }

    public AMQShortString getAppId() {
        return this._appId;
    }

    public void setAppId(String appId) {
        this.setAppId(appId == null ? null : AMQShortString.valueOf((String)appId));
    }

    public synchronized void setAppId(AMQShortString appId) {
        this._propertyFlags = appId == null ? (this._propertyFlags &= 0xFFFFFFF7) : (this._propertyFlags |= 8);
        this._appId = appId;
        this.nullEncodedForm();
    }

    public String getClusterIdAsString() {
        return this._clusterId == null ? null : this._clusterId.toString();
    }

    public AMQShortString getClusterId() {
        return this._clusterId;
    }

    public void setClusterId(String clusterId) {
        this.setClusterId(clusterId == null ? null : AMQShortString.valueOf((String)clusterId));
    }

    public synchronized void setClusterId(AMQShortString clusterId) {
        this._propertyFlags = clusterId == null ? (this._propertyFlags &= 0xFFFFFFFB) : (this._propertyFlags |= 4);
        this._clusterId = clusterId;
        this.nullEncodedForm();
    }

    public String toString() {
        return "reply-to = " + this._replyTo + ",propertyFlags = " + this._propertyFlags + ",ApplicationID = " + this._appId + ",ClusterID = " + this._clusterId + ",UserId = " + this._userId + ",JMSMessageID = " + this._messageId + ",JMSCorrelationID = " + this._correlationId + ",JMSDeliveryMode = " + this._deliveryMode + ",JMSExpiration = " + this._expiration + ",JMSPriority = " + this._priority + ",JMSTimestamp = " + this._timestamp + ",JMSType = " + this._type + ",contentType = " + this._contentType;
    }

    private synchronized boolean useEncodedForm() {
        return this._encodedForm != null;
    }

    public synchronized void dispose() {
        this.nullEncodedForm();
        this._headers.dispose();
    }

    public synchronized void clearEncodedForm() {
        this.nullEncodedForm();
        this._headers.clearEncodedForm();
    }

    private synchronized void nullEncodedForm() {
        if (this._encodedForm != null) {
            this._encodedForm.dispose();
            this._encodedForm = null;
        }
    }

    synchronized void reallocate() {
        this._headers.clearEncodedForm();
        if (this._encodedForm != null) {
            this._encodedForm = QpidByteBuffer.reallocateIfNecessary((QpidByteBuffer)this._encodedForm);
        }
    }
}

