/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.ProtocolVersion;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;
import org.apache.qpid.server.protocol.v0_8.transport.ServerChannelMethodProcessor;

public class BasicRecoverSyncBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    private int _methodId;
    public static final int CLASS_ID = 60;
    private final byte _bitfield0;

    public BasicRecoverSyncBody(ProtocolVersion protocolVersion, boolean requeue) {
        this._methodId = ProtocolVersion.v0_9.equals((Object)protocolVersion) ? 102 : 110;
        byte bitfield0 = 0;
        if (requeue) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return this._methodId;
    }

    public final boolean getRequeue() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 1;
        return size;
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicRecoverSync(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicRecoverSyncBodyImpl: ");
        buf.append("requeue=");
        buf.append(this.getRequeue());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer in, ServerChannelMethodProcessor dispatcher) {
        boolean requeue;
        boolean bl = requeue = (in.get() & 1) == 1;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicRecover(requeue, true);
        }
    }
}

