/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import java.util.Arrays;
import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ClientMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class ConnectionSecureBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 20;
    private final byte[] _challenge;

    public ConnectionSecureBody(byte[] challenge) {
        this._challenge = challenge;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 20;
    }

    public final byte[] getChallenge() {
        return this._challenge;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._challenge);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeBytes(buffer, this._challenge);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionSecure(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionSecureBodyImpl: ");
        buf.append("challenge=");
        buf.append(this.getChallenge() == null ? "null" : Arrays.toString(this.getChallenge()));
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer in, ClientMethodProcessor dispatcher) throws AMQFrameDecodingException {
        byte[] challenge = EncodingUtils.readBytes((QpidByteBuffer)in);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveConnectionSecure(challenge);
        }
    }
}

