/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ClientChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class BasicGetEmptyBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 72;
    private final AMQShortString _clusterId;

    public BasicGetEmptyBody(AMQShortString clusterId) {
        this._clusterId = clusterId;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 72;
    }

    public final AMQShortString getClusterId() {
        return this._clusterId;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._clusterId);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._clusterId);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicGetEmpty(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicGetEmptyBody: ");
        buf.append("clusterId=");
        buf.append(this.getClusterId());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ClientChannelMethodProcessor dispatcher) {
        AMQShortString clusterId = AMQShortString.readAMQShortString((QpidByteBuffer)buffer);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicGetEmpty();
        }
    }
}

