/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import com.google.common.cache.Cache;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.virtualhost.CacheFactory;
import org.apache.qpid.server.virtualhost.NullCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQShortString
implements Comparable<AMQShortString> {
    public static final int MAX_LENGTH = 255;
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQShortString.class);
    private static final NullCache<ByteBuffer, AMQShortString> NULL_CACHE = new NullCache();
    private static final ThreadLocal<Cache<ByteBuffer, AMQShortString>> CACHE = ThreadLocal.withInitial(() -> CacheFactory.getCache((String)"amqShortStringCache", NULL_CACHE));
    private final byte[] _data;
    private int _hashCode;
    private String _asString = null;
    public static final AMQShortString EMPTY_STRING = AMQShortString.createAMQShortString((String)null);

    private AMQShortString(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Cannot create AMQShortString with null data[]");
        }
        if (data.length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        this._data = data;
    }

    static byte[] readAMQShortStringAsBytes(QpidByteBuffer buffer) {
        short length = buffer.getUnsignedByte();
        if (length == 0) {
            return null;
        }
        if (length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        if (length > buffer.remaining()) {
            throw new IllegalArgumentException("Cannot create AMQShortString with length " + length + " from a ByteBuffer with only " + buffer.remaining() + " bytes.");
        }
        byte[] data = new byte[length];
        buffer.get(data, 0, (int)length);
        return data;
    }

    public static String readAMQShortStringAsString(QpidByteBuffer buffer) {
        byte[] data = AMQShortString.readAMQShortStringAsBytes(buffer);
        if (data == null) {
            return null;
        }
        return new String(data, StandardCharsets.UTF_8);
    }

    public static AMQShortString readAMQShortString(QpidByteBuffer buffer) {
        byte[] data = AMQShortString.readAMQShortStringAsBytes(buffer);
        if (data == null) {
            return null;
        }
        ByteBuffer stringBuffer = ByteBuffer.wrap(data);
        AMQShortString cached = (AMQShortString)AMQShortString.getShortStringCache().getIfPresent((Object)stringBuffer);
        if (cached == null) {
            cached = new AMQShortString(data);
            AMQShortString.getShortStringCache().put((Object)stringBuffer, (Object)cached);
        }
        return cached;
    }

    public static AMQShortString createAMQShortString(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Cannot create AMQShortString with null data[]");
        }
        AMQShortString cached = (AMQShortString)AMQShortString.getShortStringCache().getIfPresent((Object)ByteBuffer.wrap(data));
        return cached != null ? cached : new AMQShortString(data);
    }

    public static AMQShortString createAMQShortString(String string) {
        byte[] data = EncodingUtils.asUTF8Bytes(string);
        AMQShortString cached = (AMQShortString)AMQShortString.getShortStringCache().getIfPresent((Object)ByteBuffer.wrap(data));
        if (cached != null) {
            return cached;
        }
        AMQShortString shortString = new AMQShortString(data);
        int hash = 0;
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(0xFF & data[i]);
            hash = 31 * hash + data[i];
        }
        shortString._hashCode = hash;
        shortString._asString = string;
        return shortString;
    }

    public int length() {
        return this._data.length;
    }

    public char charAt(int index) {
        return (char)this._data[index];
    }

    public byte[] getBytes() {
        return (byte[])this._data.clone();
    }

    public void writeToBuffer(QpidByteBuffer buffer) {
        AMQShortString.writeShortStringBytes(buffer, this._data);
    }

    public static void writeShortString(QpidByteBuffer buffer, String data) {
        AMQShortString.writeShortStringBytes(buffer, data.getBytes(StandardCharsets.UTF_8));
    }

    private static void writeShortStringBytes(QpidByteBuffer buffer, byte[] data) {
        short size = (short)data.length;
        buffer.putUnsignedByte(size);
        buffer.put(data, 0, (int)size);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AMQShortString) {
            return this.equals((AMQShortString)o);
        }
        return false;
    }

    public boolean equals(AMQShortString otherString) {
        if (otherString == this) {
            return true;
        }
        if (otherString == null) {
            return false;
        }
        int hashCode = this._hashCode;
        int otherHashCode = otherString._hashCode;
        if (hashCode != 0 && otherHashCode != 0 && hashCode != otherHashCode) {
            return false;
        }
        int length = this._data.length;
        if (length != otherString._data.length) {
            return false;
        }
        return Arrays.equals(this._data, otherString._data);
    }

    public int hashCode() {
        int hash = this._hashCode;
        if (hash == 0) {
            int size = this.length();
            for (int i = 0; i < size; ++i) {
                hash = 31 * hash + this._data[i];
            }
            this._hashCode = hash;
        }
        return hash;
    }

    public String toString() {
        if (this._asString == null) {
            this._asString = new String(this._data, StandardCharsets.UTF_8);
        }
        return this._asString;
    }

    @Override
    public int compareTo(AMQShortString name) {
        if (name == this) {
            return 0;
        }
        if (name == null) {
            return 1;
        }
        if (name.length() < this.length()) {
            return -name.compareTo(this);
        }
        for (int i = 0; i < this.length(); ++i) {
            byte d = this._data[i];
            byte n = name._data[i];
            if (d < n) {
                return -1;
            }
            if (d <= n) continue;
            return 1;
        }
        return this.length() == name.length() ? 0 : -1;
    }

    public boolean contains(byte b) {
        int end = this._data.length;
        for (int i = 0; i < end; ++i) {
            if (this._data[i] != b) continue;
            return true;
        }
        return false;
    }

    public static AMQShortString validValueOf(Object obj) {
        return AMQShortString.valueOf(obj, true, true);
    }

    static AMQShortString valueOf(Object obj, boolean truncate, boolean nullAsEmptyString) {
        if (obj == null) {
            if (nullAsEmptyString) {
                return EMPTY_STRING;
            }
            return null;
        }
        String value = String.valueOf(obj);
        int strLength = Math.min(value.length(), 255);
        byte[] bytes = EncodingUtils.asUTF8Bytes(value);
        if (truncate) {
            while (bytes.length > 255) {
                value = value.substring(0, strLength-- - 3) + "...";
                bytes = EncodingUtils.asUTF8Bytes(value);
            }
        }
        return AMQShortString.createAMQShortString(bytes);
    }

    public static AMQShortString valueOf(Object obj) {
        return AMQShortString.valueOf(obj, false, false);
    }

    public static AMQShortString valueOf(String obj) {
        if (obj == null) {
            return null;
        }
        return AMQShortString.createAMQShortString(obj);
    }

    public static String toString(AMQShortString amqShortString) {
        return amqShortString == null ? null : amqShortString.toString();
    }

    static Cache<ByteBuffer, AMQShortString> getShortStringCache() {
        return CACHE.get();
    }

    static void setShortStringCache(Cache<ByteBuffer, AMQShortString> cache) {
        CACHE.set(cache);
    }
}

