/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoder;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoderImpl;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.typedmessage.TypedBytesContentReader;
import org.apache.qpid.typedmessage.TypedBytesFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageConverter_to_1_0<M extends ServerMessage>
implements MessageConverter<M, Message_1_0> {
    private final AMQPDescribedTypeRegistry _typeRegistry = AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer().registerTransactionLayer().registerSecurityLayer();

    public final Class<Message_1_0> getOutputClass() {
        return Message_1_0.class;
    }

    public final Message_1_0 convert(M message, VirtualHost vhost) {
        SectionEncoderImpl sectionEncoder = new SectionEncoderImpl(this._typeRegistry);
        return new Message_1_0(this.convertToStoredMessage(message, (SectionEncoder)sectionEncoder));
    }

    private StoredMessage<MessageMetaData_1_0> convertToStoredMessage(M serverMessage, SectionEncoder sectionEncoder) {
        MessageMetaData_1_0 metaData = this.convertMetaData(serverMessage, sectionEncoder);
        return this.convertServerMessage(metaData, (ServerMessage)serverMessage, sectionEncoder);
    }

    protected abstract MessageMetaData_1_0 convertMetaData(M var1, SectionEncoder var2);

    private static Section convertMessageBody(String mimeType, byte[] data) {
        if ("text/plain".equals(mimeType) || "text/xml".equals(mimeType)) {
            String text = new String(data);
            return new AmqpValue((Object)text);
        }
        if ("jms/map-message".equals(mimeType)) {
            TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            int entries = reader.readIntImpl();
            for (int i = 0; i < entries; ++i) {
                try {
                    String propName = reader.readStringImpl();
                    Object value = reader.readObject();
                    map.put(propName, value);
                    continue;
                }
                catch (EOFException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (TypedBytesFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return new AmqpValue(map);
        }
        if ("amqp/map".equals(mimeType)) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(ByteBuffer.wrap(data));
            return new AmqpValue((Object)decoder.readMap());
        }
        if ("amqp/list".equals(mimeType)) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(ByteBuffer.wrap(data));
            return new AmqpValue((Object)decoder.readList());
        }
        if ("jms/stream-message".equals(mimeType)) {
            TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
            ArrayList<Object> list = new ArrayList<Object>();
            while (reader.remaining() != 0) {
                try {
                    list.add(reader.readObject());
                }
                catch (TypedBytesFormatException e) {
                    throw new RuntimeException(e);
                }
                catch (EOFException e) {
                    throw new RuntimeException(e);
                }
            }
            return new AmqpValue(list);
        }
        return new Data(new Binary(data));
    }

    private StoredMessage<MessageMetaData_1_0> convertServerMessage(final MessageMetaData_1_0 metaData, final ServerMessage serverMessage, SectionEncoder sectionEncoder) {
        String mimeType = serverMessage.getMessageHeader().getMimeType();
        byte[] data = new byte[(int)serverMessage.getSize()];
        serverMessage.getContent(ByteBuffer.wrap(data), 0);
        Section bodySection = MessageConverter_to_1_0.convertMessageBody(mimeType, data);
        final ByteBuffer allData = this.encodeConvertedMessage(metaData, bodySection, sectionEncoder);
        return new StoredMessage<MessageMetaData_1_0>(){

            public MessageMetaData_1_0 getMetaData() {
                return metaData;
            }

            public long getMessageNumber() {
                return serverMessage.getMessageNumber();
            }

            public void addContent(int offsetInMessage, ByteBuffer src) {
                throw new UnsupportedOperationException();
            }

            public int getContent(int offsetInMessage, ByteBuffer dst) {
                int size;
                ByteBuffer buf = allData.duplicate();
                buf.position(offsetInMessage);
                buf = buf.slice();
                if (dst.remaining() < buf.remaining()) {
                    buf.limit(dst.remaining());
                    size = dst.remaining();
                } else {
                    size = buf.remaining();
                }
                dst.put(buf);
                return size;
            }

            public ByteBuffer getContent(int offsetInMessage, int size) {
                ByteBuffer buf = allData.duplicate();
                buf.position(offsetInMessage);
                buf = buf.slice();
                if (size < buf.remaining()) {
                    buf.limit(size);
                }
                return buf;
            }

            public StoreFuture flushToStore() {
                throw new UnsupportedOperationException();
            }

            public void remove() {
                serverMessage.getStoredMessage().remove();
            }
        };
    }

    private ByteBuffer encodeConvertedMessage(MessageMetaData_1_0 metaData, Section bodySection, SectionEncoder sectionEncoder) {
        int headerSize = metaData.getStorableSize();
        sectionEncoder.reset();
        sectionEncoder.encodeObject((Object)bodySection);
        Binary dataEncoding = sectionEncoder.getEncoding();
        ByteBuffer allData = ByteBuffer.allocate(headerSize + dataEncoding.getLength());
        metaData.writeToBuffer(0, allData);
        allData.put(dataEncoding.getArray(), dataEncoding.getArrayOffset(), dataEncoding.getLength());
        return allData;
    }
}

