/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQInternalException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.amqp_1_0.transport.DeliveryStateHandler;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.SendingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.SendingLinkListener;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.DeliveryState;
import org.apache.qpid.amqp_1_0.type.DistributionMode;
import org.apache.qpid.amqp_1_0.type.ErrorCondition;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.messaging.Accepted;
import org.apache.qpid.amqp_1_0.type.messaging.ExactSubjectFilter;
import org.apache.qpid.amqp_1_0.type.messaging.JMSSelectorFilter;
import org.apache.qpid.amqp_1_0.type.messaging.MatchingSubjectFilter;
import org.apache.qpid.amqp_1_0.type.messaging.Modified;
import org.apache.qpid.amqp_1_0.type.messaging.NoLocalFilter;
import org.apache.qpid.amqp_1_0.type.messaging.Released;
import org.apache.qpid.amqp_1_0.type.messaging.Source;
import org.apache.qpid.amqp_1_0.type.messaging.StdDistMode;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusDurability;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;
import org.apache.qpid.amqp_1_0.type.transport.Detach;
import org.apache.qpid.amqp_1_0.type.transport.Error;
import org.apache.qpid.amqp_1_0.type.transport.Transfer;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.filter.selector.ParseException;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.DirectExchange;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.TopicExchange;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.SimpleFilterManager;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.protocol.v1_0.Connection_1_0;
import org.apache.qpid.server.protocol.v1_0.ExchangeDestination;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.QueueDestination;
import org.apache.qpid.server.protocol.v1_0.SendingDestination;
import org.apache.qpid.server.protocol.v1_0.SendingLinkAttachment;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.Subscription_1_0;
import org.apache.qpid.server.protocol.v1_0.UnsettledAction;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.virtualhost.VirtualHost;

public class SendingLink_1_0
implements SendingLinkListener,
Link_1_0,
DeliveryStateHandler {
    private VirtualHost _vhost;
    private SendingDestination _destination;
    private Subscription_1_0 _subscription;
    private boolean _draining;
    private final Map<Binary, QueueEntry> _unsettledMap = new HashMap<Binary, QueueEntry>();
    private final ConcurrentHashMap<Binary, UnsettledAction> _unsettledActionMap = new ConcurrentHashMap();
    private volatile SendingLinkAttachment _linkAttachment;
    private TerminusDurability _durability;
    private List<QueueEntry> _resumeFullTransfers = new ArrayList<QueueEntry>();
    private List<Binary> _resumeAcceptedTransfers = new ArrayList<Binary>();
    private Runnable _closeAction;

    public SendingLink_1_0(SendingLinkAttachment linkAttachment, VirtualHost vhost, SendingDestination destination) throws AmqpErrorException {
        this._vhost = vhost;
        this._destination = destination;
        this._linkAttachment = linkAttachment;
        Source source = (Source)linkAttachment.getSource();
        this._durability = source.getDurable();
        linkAttachment.setDeliveryStateHandler(this);
        QueueDestination qd = null;
        AMQQueue queue = null;
        boolean noLocal = false;
        org.apache.qpid.server.filter.JMSSelectorFilter messageFilter = null;
        if (destination instanceof QueueDestination) {
            queue = ((QueueDestination)this._destination).getQueue();
            if (queue.getArguments() != null && queue.getArguments().containsKey("topic")) {
                source.setDistributionMode((DistributionMode)StdDistMode.COPY);
            }
            qd = (QueueDestination)destination;
            Map filters = source.getFilter();
            HashMap actualFilters = new HashMap();
            if (filters != null) {
                for (Map.Entry entry : filters.entrySet()) {
                    if (entry.getValue() instanceof NoLocalFilter) {
                        actualFilters.put(entry.getKey(), entry.getValue());
                        noLocal = true;
                        continue;
                    }
                    if (messageFilter != null || !(entry.getValue() instanceof JMSSelectorFilter)) continue;
                    JMSSelectorFilter selectorFilter = (JMSSelectorFilter)entry.getValue();
                    try {
                        messageFilter = new org.apache.qpid.server.filter.JMSSelectorFilter(selectorFilter.getValue());
                        actualFilters.put(entry.getKey(), entry.getValue());
                    }
                    catch (ParseException e) {
                        Error error = new Error();
                        error.setCondition((ErrorCondition)AmqpError.INVALID_FIELD);
                        error.setDescription("Invalid JMS Selector: " + selectorFilter.getValue());
                        error.setInfo(Collections.singletonMap(Symbol.valueOf((String)"field"), Symbol.valueOf((String)"filter")));
                        throw new AmqpErrorException(error);
                    }
                    catch (SelectorParsingException e) {
                        Error error = new Error();
                        error.setCondition((ErrorCondition)AmqpError.INVALID_FIELD);
                        error.setDescription("Invalid JMS Selector: " + selectorFilter.getValue());
                        error.setInfo(Collections.singletonMap(Symbol.valueOf((String)"field"), Symbol.valueOf((String)"filter")));
                        throw new AmqpErrorException(error);
                    }
                }
            }
            source.setFilter(actualFilters.isEmpty() ? null : actualFilters);
            this._subscription = new Subscription_1_0(this, qd);
        } else if (destination instanceof ExchangeDestination) {
            try {
                String name;
                boolean isDurable;
                ExchangeDestination exchangeDestination = (ExchangeDestination)destination;
                boolean bl = isDurable = exchangeDestination.getDurability() == TerminusDurability.CONFIGURATION || exchangeDestination.getDurability() == TerminusDurability.UNSETTLED_STATE;
                if (isDurable) {
                    String remoteContainerId = this.getEndpoint().getSession().getConnection().getRemoteContainerId();
                    remoteContainerId = remoteContainerId.replace("_", "__").replace(".", "_:");
                    String endpointName = linkAttachment.getEndpoint().getName();
                    endpointName = endpointName.replace("_", "__").replace(".", "_:").replace("(", "_O").replace(")", "_C").replace("<", "_L").replace(">", "_R");
                    name = "qpid_/" + remoteContainerId + "_/" + endpointName;
                } else {
                    name = UUID.randomUUID().toString();
                }
                queue = this._vhost.getQueueRegistry().getQueue(name);
                Exchange exchange = exchangeDestination.getExchange();
                if (queue == null) {
                    queue = AMQQueueFactory.createAMQQueueImpl((UUID)UUIDGenerator.generateQueueUUID((String)name, (String)this._vhost.getName()), (String)name, (boolean)isDurable, null, (boolean)true, (boolean)true, (VirtualHost)this._vhost, (Map)Collections.EMPTY_MAP);
                } else {
                    List bindings = queue.getBindings();
                    ArrayList<Binding> bindingsToRemove = new ArrayList<Binding>();
                    for (Binding existingBinding : bindings) {
                        if (existingBinding.getExchange() == this._vhost.getDefaultExchange() || existingBinding.getExchange() == exchange) continue;
                        bindingsToRemove.add(existingBinding);
                    }
                    for (Binding existingBinding : bindingsToRemove) {
                        existingBinding.getExchange().removeBinding(existingBinding);
                    }
                }
                String binding = "";
                Map filters = source.getFilter();
                HashMap actualFilters = new HashMap();
                boolean hasBindingFilter = false;
                if (filters != null && !filters.isEmpty()) {
                    for (Map.Entry entry : filters.entrySet()) {
                        ExactSubjectFilter filter;
                        if (!hasBindingFilter && entry.getValue() instanceof ExactSubjectFilter && exchange.getType() == DirectExchange.TYPE) {
                            filter = (ExactSubjectFilter)filters.values().iterator().next();
                            source.setFilter(filters);
                            binding = filter.getValue();
                            actualFilters.put(entry.getKey(), entry.getValue());
                            hasBindingFilter = true;
                            continue;
                        }
                        if (!hasBindingFilter && entry.getValue() instanceof MatchingSubjectFilter && exchange.getType() == TopicExchange.TYPE) {
                            filter = (MatchingSubjectFilter)filters.values().iterator().next();
                            source.setFilter(filters);
                            binding = filter.getValue();
                            actualFilters.put(entry.getKey(), entry.getValue());
                            hasBindingFilter = true;
                            continue;
                        }
                        if (entry.getValue() instanceof NoLocalFilter) {
                            actualFilters.put(entry.getKey(), entry.getValue());
                            noLocal = true;
                            continue;
                        }
                        if (messageFilter != null || !(entry.getValue() instanceof JMSSelectorFilter)) continue;
                        JMSSelectorFilter selectorFilter = (JMSSelectorFilter)entry.getValue();
                        try {
                            messageFilter = new org.apache.qpid.server.filter.JMSSelectorFilter(selectorFilter.getValue());
                            actualFilters.put(entry.getKey(), entry.getValue());
                        }
                        catch (ParseException e) {
                            Error error = new Error();
                            error.setCondition((ErrorCondition)AmqpError.INVALID_FIELD);
                            error.setDescription("Invalid JMS Selector: " + selectorFilter.getValue());
                            error.setInfo(Collections.singletonMap(Symbol.valueOf((String)"field"), Symbol.valueOf((String)"filter")));
                            throw new AmqpErrorException(error);
                        }
                        catch (SelectorParsingException e) {
                            Error error = new Error();
                            error.setCondition((ErrorCondition)AmqpError.INVALID_FIELD);
                            error.setDescription("Invalid JMS Selector: " + selectorFilter.getValue());
                            error.setInfo(Collections.singletonMap(Symbol.valueOf((String)"field"), Symbol.valueOf((String)"filter")));
                            throw new AmqpErrorException(error);
                        }
                    }
                }
                source.setFilter(actualFilters.isEmpty() ? null : actualFilters);
                exchange.addBinding(binding, queue, null);
                source.setDistributionMode((DistributionMode)StdDistMode.COPY);
                if (!isDurable) {
                    final String queueName = name;
                    final AMQQueue tempQueue = queue;
                    final Connection_1_0.Task deleteQueueTask = new Connection_1_0.Task(){

                        public void doTask(Connection_1_0 session) {
                            if (SendingLink_1_0.this._vhost.getQueueRegistry().getQueue(queueName) == tempQueue) {
                                try {
                                    tempQueue.delete();
                                }
                                catch (AMQException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    };
                    this.getSession().getConnection().addConnectionCloseTask(deleteQueueTask);
                    queue.addQueueDeleteTask(new AMQQueue.Task(){

                        public void doTask(AMQQueue queue) {
                            SendingLink_1_0.this.getSession().getConnection().removeConnectionCloseTask(deleteQueueTask);
                        }
                    });
                }
                qd = new QueueDestination(queue);
            }
            catch (AMQSecurityException e) {
                e.printStackTrace();
            }
            catch (AMQInternalException e) {
                e.printStackTrace();
            }
            catch (AMQException e) {
                e.printStackTrace();
            }
            this._subscription = new Subscription_1_0(this, qd, true);
        }
        if (this._subscription != null) {
            this._subscription.setNoLocal(noLocal);
            if (messageFilter != null) {
                this._subscription.setFilters((FilterManager)new SimpleFilterManager(messageFilter));
            }
            try {
                queue.registerSubscription((Subscription)this._subscription, false);
            }
            catch (AMQException e) {
                e.printStackTrace();
            }
        }
    }

    public void resume(SendingLinkAttachment linkAttachment) {
        this._linkAttachment = linkAttachment;
    }

    public void remoteDetached(LinkEndpoint endpoint, Detach detach) {
        if (!TerminusDurability.UNSETTLED_STATE.equals(this._durability)) {
            AMQQueue queue = this._subscription.getQueue();
            try {
                queue.unregisterSubscription((Subscription)this._subscription);
            }
            catch (AMQException e) {
                e.printStackTrace();
            }
            Modified state = new Modified();
            state.setDeliveryFailed(Boolean.valueOf(true));
            for (UnsettledAction action : this._unsettledActionMap.values()) {
                action.process((DeliveryState)state, Boolean.TRUE);
            }
            this._unsettledActionMap.clear();
            endpoint.close();
            if (this._destination instanceof ExchangeDestination && (this._durability == TerminusDurability.CONFIGURATION || this._durability == TerminusDurability.UNSETTLED_STATE)) {
                try {
                    queue.delete();
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
            if (this._closeAction != null) {
                this._closeAction.run();
            }
        } else if (detach == null || detach.getError() != null) {
            this._linkAttachment = null;
            this._subscription.flowStateChanged();
        } else {
            endpoint.detach();
        }
    }

    public void start() {
    }

    public SendingLinkEndpoint getEndpoint() {
        return this._linkAttachment == null ? null : this._linkAttachment.getEndpoint();
    }

    public Session_1_0 getSession() {
        return this._linkAttachment == null ? null : this._linkAttachment.getSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flowStateChanged() {
        if (Boolean.TRUE.equals(this.getEndpoint().getDrain()) && this.hasCredit()) {
            this._draining = true;
        }
        while (!this._resumeAcceptedTransfers.isEmpty() && this.getEndpoint().hasCreditToSend()) {
            Accepted accepted = new Accepted();
            Object object = this.getLock();
            synchronized (object) {
                Transfer xfr = new Transfer();
                Binary dt = this._resumeAcceptedTransfers.remove(0);
                xfr.setDeliveryTag(dt);
                xfr.setState((DeliveryState)accepted);
                xfr.setResume(Boolean.TRUE);
                this.getEndpoint().transfer(xfr);
            }
        }
        if (this._resumeAcceptedTransfers.isEmpty()) {
            this._subscription.flowStateChanged();
        }
    }

    boolean hasCredit() {
        return this.getEndpoint().getLinkCredit().compareTo(UnsignedInteger.ZERO) > 0;
    }

    public boolean isDraining() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drained() {
        if (this.getEndpoint() != null) {
            Object object = this.getEndpoint().getLock();
            synchronized (object) {
                if (this._draining) {
                    this.getEndpoint().drained();
                    this._draining = false;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void addUnsettled(Binary tag, UnsettledAction unsettledAction, QueueEntry queueEntry) {
        this._unsettledActionMap.put(tag, unsettledAction);
        if (this.getTransactionId() == null) {
            this._unsettledMap.put(tag, queueEntry);
        }
    }

    public void removeUnsettled(Binary tag) {
        this._unsettledActionMap.remove(tag);
    }

    public void handle(Binary deliveryTag, DeliveryState state, Boolean settled) {
        UnsettledAction action = this._unsettledActionMap.get(deliveryTag);
        boolean localSettle = false;
        if (action != null && (localSettle = action.process(state, settled)) && !Boolean.TRUE.equals(settled)) {
            this._linkAttachment.updateDisposition(deliveryTag, state, true);
        }
        if (Boolean.TRUE.equals(settled) || localSettle) {
            this._unsettledActionMap.remove(deliveryTag);
            this._unsettledMap.remove(deliveryTag);
        }
    }

    ServerTransaction getTransaction(Binary transactionId) {
        return this._linkAttachment.getSession().getTransaction(transactionId);
    }

    public Binary getTransactionId() {
        SendingLinkEndpoint endpoint = this.getEndpoint();
        return endpoint == null ? null : endpoint.getTransactionId();
    }

    public synchronized Object getLock() {
        return this._linkAttachment == null ? this : this.getEndpoint().getLock();
    }

    public boolean isDetached() {
        return this._linkAttachment == null || this.getEndpoint().isDetached();
    }

    public boolean isAttached() {
        return this._linkAttachment != null && this.getEndpoint().isAttached();
    }

    public synchronized void setLinkAttachment(SendingLinkAttachment linkAttachment) {
        if (this._subscription.isActive()) {
            this._subscription.suspend();
        }
        this._linkAttachment = linkAttachment;
        SendingLinkEndpoint endpoint = linkAttachment.getEndpoint();
        endpoint.setDeliveryStateHandler((DeliveryStateHandler)this);
        Map initialUnsettledMap = endpoint.getInitialUnsettledMap();
        HashMap<Binary, QueueEntry> unsettledCopy = new HashMap<Binary, QueueEntry>(this._unsettledMap);
        this._resumeAcceptedTransfers.clear();
        this._resumeFullTransfers.clear();
        for (Map.Entry entry : unsettledCopy.entrySet()) {
            Binary deliveryTag = (Binary)entry.getKey();
            final QueueEntry queueEntry = (QueueEntry)entry.getValue();
            if (initialUnsettledMap == null || !initialUnsettledMap.containsKey(deliveryTag)) {
                queueEntry.setRedelivered();
                queueEntry.release();
                this._unsettledMap.remove(deliveryTag);
                continue;
            }
            if (initialUnsettledMap != null && initialUnsettledMap.get(deliveryTag) instanceof Outcome) {
                AutoCommitTransaction txn;
                Outcome outcome = (Outcome)initialUnsettledMap.get(deliveryTag);
                if (outcome instanceof Accepted) {
                    txn = new AutoCommitTransaction(this._vhost.getMessageStore());
                    if (this._subscription.acquires()) {
                        txn.dequeue(Collections.singleton(queueEntry), new ServerTransaction.Action(){

                            public void postCommit() {
                                queueEntry.discard();
                            }

                            public void onRollback() {
                            }
                        });
                    }
                } else if (outcome instanceof Released) {
                    txn = new AutoCommitTransaction(this._vhost.getMessageStore());
                    if (this._subscription.acquires()) {
                        txn.dequeue(Collections.singleton(queueEntry), new ServerTransaction.Action(){

                            public void postCommit() {
                                queueEntry.release();
                            }

                            public void onRollback() {
                            }
                        });
                    }
                }
                initialUnsettledMap.remove(deliveryTag);
                this._resumeAcceptedTransfers.add(deliveryTag);
                continue;
            }
            this._resumeFullTransfers.add(queueEntry);
        }
    }

    public Map getUnsettledOutcomeMap() {
        HashMap<Binary, QueueEntry> unsettled = new HashMap<Binary, QueueEntry>(this._unsettledMap);
        for (Map.Entry entry : unsettled.entrySet()) {
            entry.setValue(null);
        }
        return unsettled;
    }

    public void setCloseAction(Runnable action) {
        this._closeAction = action;
    }
}

