/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.configuration.CommonProperties;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.ConnectionClosingTicker;
import org.apache.qpid.server.protocol.v1_0.ConnectionHandler;
import org.apache.qpid.server.protocol.v1_0.ConnectionState;
import org.apache.qpid.server.protocol.v1_0.Container;
import org.apache.qpid.server.protocol.v1_0.ErrorHandler;
import org.apache.qpid.server.protocol.v1_0.FrameOutputHandler;
import org.apache.qpid.server.protocol.v1_0.SASLEndpoint;
import org.apache.qpid.server.protocol.v1_0.SaslServerProvider;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructorRegistry;
import org.apache.qpid.server.protocol.v1_0.codec.FrameWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ProtocolHandler;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.framing.AMQFrame;
import org.apache.qpid.server.protocol.v1_0.framing.FrameHandler;
import org.apache.qpid.server.protocol.v1_0.framing.OversizeFrameException;
import org.apache.qpid.server.protocol.v1_0.framing.SASLFrame;
import org.apache.qpid.server.protocol.v1_0.framing.TransportFrame;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.FrameBody;
import org.apache.qpid.server.protocol.v1_0.type.SaslFrameBody;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedShort;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.protocol.v1_0.type.security.SaslChallenge;
import org.apache.qpid.server.protocol.v1_0.type.security.SaslCode;
import org.apache.qpid.server.protocol.v1_0.type.security.SaslInit;
import org.apache.qpid.server.protocol.v1_0.type.security.SaslMechanisms;
import org.apache.qpid.server.protocol.v1_0.type.security.SaslOutcome;
import org.apache.qpid.server.protocol.v1_0.type.security.SaslResponse;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Begin;
import org.apache.qpid.server.protocol.v1_0.type.transport.Close;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Detach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Disposition;
import org.apache.qpid.server.protocol.v1_0.type.transport.End;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.Flow;
import org.apache.qpid.server.protocol.v1_0.type.transport.Open;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AnonymousAuthenticationManager;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.transport.AbstractAMQPConnection;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.transport.network.Ticker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPConnection_1_0
extends AbstractAMQPConnection<AMQPConnection_1_0>
implements FrameOutputHandler,
DescribedTypeConstructorRegistry.Source,
ValueWriter.Registry.Source,
ErrorHandler,
SASLEndpoint,
ConnectionHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(AMQPConnection_1_0.class);
    private static final Logger FRAME_LOGGER = LoggerFactory.getLogger((String)"FRM");
    private static final long CLOSE_RESPONSE_TIMEOUT = 10000L;
    private final AtomicBoolean _stateChanged = new AtomicBoolean();
    private final AtomicReference<Action<ProtocolEngine>> _workListener = new AtomicReference();
    private static final byte[] SASL_HEADER = new byte[]{65, 77, 81, 80, 3, 1, 0, 0};
    private static final byte[] AMQP_HEADER = new byte[]{65, 77, 81, 80, 0, 1, 0, 0};
    private FrameWriter _frameWriter;
    private ProtocolHandler _frameHandler;
    private volatile boolean _transportBlockedForWriting;
    private volatile SubjectAuthenticationResult _successfulAuthenticationResult;
    private volatile FrameReceivingState _frameReceivingState = FrameReceivingState.AMQP_OR_SASL_HEADER;
    private static final short CONNECTION_CONTROL_CHANNEL = 0;
    private static final QpidByteBuffer EMPTY_BYTE_BUFFER = QpidByteBuffer.wrap((byte[])new byte[0]);
    private static final int DEFAULT_CHANNEL_MAX = Math.min(Integer.getInteger("amqp.channel_max", 255), 65535);
    private static final int DEFAULT_MAX_FRAME = Integer.getInteger("amqp.max_frame_size", 32768);
    private AmqpPort<?> _port;
    private SubjectCreator _subjectCreator;
    private Transport _transport;
    private long _connectionId;
    private Container _container;
    private int _channelMax = DEFAULT_CHANNEL_MAX;
    private int _maxFrameSize = 4096;
    private String _remoteContainerId;
    private SocketAddress _remoteAddress;
    private Session_1_0[] _sendingSessions;
    private Session_1_0[] _receivingSessions;
    private boolean _closedForInput;
    private boolean _closedForOutput;
    private long _idleTimeout;
    private ConnectionState _connectionState = ConnectionState.UNOPENED;
    private AMQPDescribedTypeRegistry _describedTypeRegistry = AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer().registerTransactionLayer().registerSecurityLayer();
    private Map _properties;
    private SaslServerProvider _saslServerProvider;
    private boolean _saslComplete;
    private SaslServer _saslServer;
    private String _localHostname;
    private long _desiredIdleTimeout;
    private UnsignedInteger _handleMax = UnsignedInteger.MAX_VALUE;
    private Error _remoteError;
    private static final long MINIMUM_SUPPORTED_IDLE_TIMEOUT = 1000L;
    private Map _remoteProperties;
    private final AtomicBoolean _orderlyClose = new AtomicBoolean(false);
    private final Collection<Session_1_0> _sessions = Collections.synchronizedCollection(new ArrayList());
    private final Object _reference = new Object();
    private final Queue<Action<? super ConnectionHandler>> _asyncTaskList = new ConcurrentLinkedQueue<Action<? super ConnectionHandler>>();
    private boolean _closedOnOpen;

    AMQPConnection_1_0(Broker<?> broker, ServerNetworkConnection network, AmqpPort<?> port, Transport transport, long id, AggregateTicker aggregateTicker, boolean useSASL) {
        super(broker, network, port, transport, Protocol.AMQP_1_0, id, aggregateTicker);
        this._container = new Container(broker.getId().toString());
        this._subjectCreator = port.getAuthenticationProvider().getSubjectCreator(transport.isSecure());
        this._saslServerProvider = useSASL ? AMQPConnection_1_0.asSaslServerProvider(this._subjectCreator, network) : null;
        this._port = port;
        this._transport = transport;
        this._connectionId = id;
        LinkedHashMap<Symbol, Object> serverProperties = new LinkedHashMap<Symbol, Object>();
        serverProperties.put(Symbol.valueOf("product"), CommonProperties.getProductName());
        serverProperties.put(Symbol.valueOf("version"), CommonProperties.getReleaseVersion());
        serverProperties.put(Symbol.valueOf("qpid.build"), CommonProperties.getBuildVersion());
        serverProperties.put(Symbol.valueOf("qpid.instance_name"), broker.getName());
        this.setProperties(serverProperties);
        this.setRemoteAddress(network.getRemoteAddress());
        this.setDesiredIdleTimeout(1000L * (long)broker.getConnection_heartBeatDelay());
        this._frameWriter = new FrameWriter(this.getDescribedTypeRegistry(), this.getSender());
    }

    private void setUserPrincipal(Principal user) {
        this.setSubject(this._subjectCreator.createSubjectWithGroups(user));
    }

    private long getDesiredIdleTimeout() {
        return this._desiredIdleTimeout;
    }

    @Override
    public void receiveAttach(short channel, final Attach attach) {
        this.assertState(FrameReceivingState.ANY_FRAME);
        final Session_1_0 session = this.getSession(channel);
        if (session != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    session.receiveAttach(attach);
                    return null;
                }
            }, session.getAccessControllerContext());
        }
    }

    @Override
    public void receive(short channel, Object frame) {
        FRAME_LOGGER.debug("RECV[{}|{}] : {}", new Object[]{this._remoteAddress, channel, frame});
        if (frame instanceof FrameBody) {
            ((FrameBody)frame).invoke(channel, this);
        } else if (frame instanceof SaslFrameBody) {
            ((SaslFrameBody)frame).invoke(channel, this);
        }
    }

    private void closeSaslWithFailure() {
        this._saslComplete = true;
        this._frameReceivingState = FrameReceivingState.CLOSED;
        this.setClosedForInput(true);
        this.close();
    }

    @Override
    public void receiveSaslChallenge(SaslChallenge saslChallenge) {
        this.closeSaslWithFailure();
    }

    @Override
    public void receiveClose(short channel, Close close) {
        this.assertState(FrameReceivingState.ANY_FRAME);
        this._frameReceivingState = FrameReceivingState.CLOSED;
        this.setClosedForInput(true);
        this.closeReceived();
        switch (this._connectionState) {
            case UNOPENED: 
            case AWAITING_OPEN: {
                Error error = new Error();
                error.setCondition(ConnectionError.CONNECTION_FORCED);
                error.setDescription("Connection close sent before connection was opened");
                this.closeConnection(error);
                break;
            }
            case OPEN: {
                this._connectionState = ConnectionState.CLOSE_RECEIVED;
                this.sendClose(new Close());
                this._connectionState = ConnectionState.CLOSED;
                this._orderlyClose.set(true);
                break;
            }
            case CLOSE_SENT: {
                this._connectionState = ConnectionState.CLOSED;
                this._orderlyClose.set(true);
            }
        }
        this._remoteError = close.getError();
    }

    private void closeReceived() {
        ArrayList<Session_1_0> sessions = new ArrayList<Session_1_0>(this._sessions);
        for (final Session_1_0 session : sessions) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    session.remoteEnd(new End());
                    return null;
                }
            }, session.getAccessControllerContext());
        }
    }

    private void setClosedForInput(boolean closed) {
        this._closedForInput = closed;
    }

    @Override
    public void receiveSaslMechanisms(SaslMechanisms saslMechanisms) {
        this.closeSaslWithFailure();
    }

    @Override
    public void receiveSaslResponse(SaslResponse saslResponse) {
        Binary responseBinary = saslResponse.getResponse();
        byte[] response = responseBinary == null ? new byte[]{} : responseBinary.getArray();
        this.assertState(FrameReceivingState.SASL_RESPONSE_ONLY);
        this.processSaslResponse(response);
    }

    @Override
    public AMQPDescribedTypeRegistry getDescribedTypeRegistry() {
        return this._describedTypeRegistry;
    }

    private void closeSessionAsync(final Session_1_0 session, final AMQConstant cause, final String message) {
        this.addAsyncTask(new Action<ConnectionHandler>(){

            public void performAction(ConnectionHandler object) {
                session.close(cause, message);
            }
        });
    }

    private boolean closedForOutput() {
        return this._closedForOutput;
    }

    public boolean isClosed() {
        return this._connectionState == ConnectionState.CLOSED || this._connectionState == ConnectionState.CLOSE_RECEIVED;
    }

    @Override
    public boolean closedForInput() {
        return this._closedForInput;
    }

    void sessionEnded(Session_1_0 session) {
        if (!this._closedOnOpen) {
            this._sessions.remove(session);
            this.sessionRemoved(session);
        }
    }

    public int send(short channel, FrameBody body, QpidByteBuffer payload) {
        return this.sendFrame(channel, body, payload);
    }

    private void inputClosed() {
        if (!this._closedForInput) {
            this._closedForInput = true;
            FRAME_LOGGER.debug("RECV[{}] : {}", (Object)this._remoteAddress, (Object)"Underlying connection closed");
            switch (this._connectionState) {
                case UNOPENED: 
                case AWAITING_OPEN: 
                case CLOSE_SENT: {
                    this._connectionState = ConnectionState.CLOSED;
                    this.closeSender();
                    break;
                }
                case OPEN: {
                    this._connectionState = ConnectionState.CLOSE_RECEIVED;
                }
                case CLOSED: {
                    break;
                }
            }
            this.closeReceived();
        }
    }

    private void closeSender() {
        this.setClosedForOutput(true);
        this.close();
    }

    String getRemoteContainerId() {
        return this._remoteContainerId;
    }

    private void setDesiredIdleTimeout(long desiredIdleTimeout) {
        this._desiredIdleTimeout = desiredIdleTimeout;
    }

    public boolean isOpen() {
        return this._connectionState == ConnectionState.OPEN;
    }

    void sendEnd(short channel, End end, boolean remove) {
        this.sendFrame(channel, end);
        if (remove) {
            this._sendingSessions[channel] = null;
        }
    }

    @Override
    public void receiveSaslOutcome(SaslOutcome saslOutcome) {
        this.closeSaslWithFailure();
    }

    @Override
    public void receiveEnd(short channel, End end) {
        this.assertState(FrameReceivingState.ANY_FRAME);
        Session_1_0 endpoint = this._receivingSessions[channel];
        if (endpoint != null) {
            this._receivingSessions[channel] = null;
            endpoint.receiveEnd(end);
        }
    }

    @Override
    public void receiveDisposition(short channel, final Disposition disposition) {
        this.assertState(FrameReceivingState.ANY_FRAME);
        final Session_1_0 session = this.getSession(channel);
        if (session != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    session.receiveDisposition(disposition);
                    return null;
                }
            }, session.getAccessControllerContext());
        }
    }

    @Override
    public void receiveBegin(short channel, Begin begin) {
        this.assertState(FrameReceivingState.ANY_FRAME);
        if (begin.getRemoteChannel() != null) {
            Error error = new Error();
            error.setCondition(ConnectionError.FRAMING_ERROR);
            error.setDescription("BEGIN received on channel " + channel + " with given remote-channel " + begin.getRemoteChannel() + ". Since the broker does not spontaneously start channels, this must be an error.");
            this.closeConnection(error);
        } else if (this._receivingSessions[channel] == null) {
            Session_1_0 session;
            short myChannelId = this.getFirstFreeChannel();
            if (myChannelId == -1) {
                Error error = new Error();
                error.setCondition(ConnectionError.FRAMING_ERROR);
                error.setDescription("BEGIN received on channel " + channel + ". There are no free channels for the broker to responsd on.");
                this.closeConnection(error);
            }
            this._receivingSessions[channel] = session = new Session_1_0(this, begin);
            this._sendingSessions[myChannelId] = session;
            Begin beginToSend = new Begin();
            session.setReceivingChannel(channel);
            session.setSendingChannel(myChannelId);
            beginToSend.setRemoteChannel(UnsignedShort.valueOf(channel));
            beginToSend.setNextOutgoingId(session.getNextOutgoingId());
            beginToSend.setOutgoingWindow(session.getOutgoingWindowSize());
            beginToSend.setIncomingWindow(session.getIncomingWindowSize());
            this.sendFrame(myChannelId, beginToSend);
            this._sessions.add(session);
            this.sessionAdded(session);
        } else {
            Error error = new Error();
            error.setCondition(ConnectionError.FRAMING_ERROR);
            error.setDescription("BEGIN received on channel " + channel + " which is already in use.");
            this.closeConnection(error);
        }
    }

    private short getFirstFreeChannel() {
        for (int i = 0; i <= this._channelMax; ++i) {
            if (this._sendingSessions[i] != null) continue;
            return (short)i;
        }
        return -1;
    }

    @Override
    public void handleError(Error error) {
        if (!this.closedForOutput()) {
            Close close = new Close();
            close.setError(error);
            this.sendFrame((short)0, close);
            this.setClosedForOutput(true);
        }
    }

    @Override
    public void receiveTransfer(short channel, final Transfer transfer) {
        this.assertState(FrameReceivingState.ANY_FRAME);
        final Session_1_0 session = this.getSession(channel);
        if (session != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    session.receiveTransfer(transfer);
                    return null;
                }
            }, session.getAccessControllerContext());
        }
    }

    @Override
    public void receiveFlow(short channel, final Flow flow) {
        this.assertState(FrameReceivingState.ANY_FRAME);
        final Session_1_0 session = this.getSession(channel);
        if (session != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    session.receiveFlow(flow);
                    return null;
                }
            }, session.getAccessControllerContext());
        }
    }

    @Override
    public void receiveOpen(short channel, Open open) {
        this.assertState(FrameReceivingState.OPEN_ONLY);
        this._frameReceivingState = FrameReceivingState.ANY_FRAME;
        int n = open.getChannelMax() == null ? this._channelMax : (this._channelMax = open.getChannelMax().intValue() < this._channelMax ? open.getChannelMax().intValue() : this._channelMax);
        if (this._receivingSessions == null) {
            this._receivingSessions = new Session_1_0[this._channelMax + 1];
            this._sendingSessions = new Session_1_0[this._channelMax + 1];
        }
        this._maxFrameSize = open.getMaxFrameSize() == null ? DEFAULT_MAX_FRAME : open.getMaxFrameSize().intValue();
        this._remoteContainerId = open.getContainerId();
        this._localHostname = open.getHostname();
        if (open.getIdleTimeOut() != null) {
            this._idleTimeout = open.getIdleTimeOut().longValue();
        }
        this._remoteProperties = open.getProperties();
        if (this._remoteProperties != null) {
            if (this._remoteProperties.containsKey(Symbol.valueOf("product"))) {
                this.setClientProduct(this._remoteProperties.get(Symbol.valueOf("product")).toString());
            }
            if (this._remoteProperties.containsKey(Symbol.valueOf("version"))) {
                this.setClientVersion(this._remoteProperties.get(Symbol.valueOf("version")).toString());
            }
            this.setClientId(this._remoteContainerId);
        }
        if (this._idleTimeout != 0L && this._idleTimeout < 1000L) {
            this.closeConnection(new Error(ConnectionError.CONNECTION_FORCED, "Requested idle timeout of " + this._idleTimeout + " is too low. The minimum supported timeout is" + 1000L));
            this.close();
            this._closedOnOpen = true;
        } else {
            long desiredIdleTimeout = this.getDesiredIdleTimeout();
            this.initialiseHeartbeating(this._idleTimeout / 2L, desiredIdleTimeout);
            NamedAddressSpace addressSpace = this._port.getAddressSpace(this._localHostname);
            if (addressSpace == null) {
                this.closeWithError(AmqpError.NOT_FOUND, "Unknown hostname in connection open: '" + this._localHostname + "'");
            } else if (!addressSpace.isActive()) {
                Error err = new Error();
                err.setCondition(AmqpError.NOT_FOUND);
                this.closeConnection(err);
                this._closedOnOpen = true;
                this.populateConnectionRedirect(addressSpace, err);
                this.closeConnection(err);
                this.close();
                this._closedOnOpen = true;
            } else if (AuthenticatedPrincipal.getOptionalAuthenticatedPrincipalFromSubject((Subject)this.getSubject()) == null) {
                this.closeWithError(AmqpError.NOT_ALLOWED, "Connection has not been authenticated");
            } else {
                try {
                    this.setAddressSpace(addressSpace);
                }
                catch (VirtualHostUnavailableException e) {
                    this.closeWithError(AmqpError.NOT_ALLOWED, e.getMessage());
                }
            }
        }
        switch (this._connectionState) {
            case UNOPENED: {
                this.sendOpen(this._channelMax, this._maxFrameSize);
            }
            case AWAITING_OPEN: {
                this._connectionState = ConnectionState.OPEN;
            }
        }
    }

    private void populateConnectionRedirect(NamedAddressSpace addressSpace, Error err) {
        String redirectHost = addressSpace.getRedirectHost(this._port);
        if (redirectHost == null) {
            err.setDescription("Virtual host '" + this._localHostname + "' is not active");
        } else {
            int port;
            String networkHost;
            if (redirectHost.matches("\\[[0-9a-f:]+\\](:[0-9]+)?")) {
                networkHost = redirectHost.substring(1, redirectHost.indexOf("]"));
                port = redirectHost.contains("]:") ? Integer.parseInt(redirectHost.substring(redirectHost.indexOf("]") + 2)) : -1;
            } else if (redirectHost.contains(":")) {
                networkHost = redirectHost.substring(0, redirectHost.lastIndexOf(":"));
                try {
                    String portString = redirectHost.substring(redirectHost.lastIndexOf(":") + 1);
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    port = -1;
                }
            } else {
                networkHost = redirectHost;
                port = -1;
            }
            HashMap<Symbol, Object> infoMap = new HashMap<Symbol, Object>();
            infoMap.put(Symbol.valueOf("network-host"), networkHost);
            if (port > 0) {
                infoMap.put(Symbol.valueOf("port"), UnsignedInteger.valueOf(port));
            }
            err.setInfo(infoMap);
        }
    }

    @Override
    public void receiveDetach(short channel, final Detach detach) {
        this.assertState(FrameReceivingState.ANY_FRAME);
        final Session_1_0 session = this.getSession(channel);
        if (session != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    session.receiveDetach(detach);
                    return null;
                }
            }, session.getAccessControllerContext());
        }
    }

    private void transportStateChanged() {
        for (Session_1_0 session : this._sessions) {
            session.transportStateChanged();
        }
    }

    public void close(Error error) {
        this.closeConnection(error);
    }

    private void setRemoteAddress(SocketAddress remoteAddress) {
        this._remoteAddress = remoteAddress;
    }

    public void setProperties(Map<Symbol, Object> properties) {
        this._properties = properties;
    }

    private void setClosedForOutput(boolean closed) {
        this._closedForOutput = closed;
    }

    @Override
    public void receiveSaslInit(SaslInit saslInit) {
        this.assertState(FrameReceivingState.SASL_INIT_ONLY);
        String mechanism = saslInit.getMechanism() == null ? null : saslInit.getMechanism().toString();
        Binary initialResponse = saslInit.getInitialResponse();
        byte[] response = initialResponse == null ? new byte[]{} : initialResponse.getArray();
        try {
            this._saslServer = this._saslServerProvider.getSaslServer(mechanism, "localhost");
            this.processSaslResponse(response);
        }
        catch (SaslException e) {
            this.handleSaslError();
        }
    }

    private void processSaslResponse(byte[] response) {
        byte[] challenge = null;
        SubjectAuthenticationResult authenticationResult = this._successfulAuthenticationResult;
        if (authenticationResult == null) {
            authenticationResult = this._subjectCreator.authenticate(this._saslServer, response != null ? response : new byte[]{});
            challenge = authenticationResult.getChallenge();
        }
        if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
            this._successfulAuthenticationResult = authenticationResult;
            if (challenge == null || challenge.length == 0) {
                this.setSubject(this._successfulAuthenticationResult.getSubject());
                SaslOutcome outcome = new SaslOutcome();
                outcome.setCode(SaslCode.OK);
                this.send((AMQFrame)new SASLFrame(outcome), (ByteBuffer)null);
                this._saslComplete = true;
                this._frameReceivingState = FrameReceivingState.AMQP_HEADER;
            } else {
                this.continueSaslNegotiation(challenge);
            }
        } else if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.CONTINUE) {
            this.continueSaslNegotiation(challenge);
        } else {
            this.handleSaslError();
        }
    }

    private void continueSaslNegotiation(byte[] challenge) {
        SaslChallenge challengeBody = new SaslChallenge();
        challengeBody.setChallenge(new Binary(challenge));
        this.send((AMQFrame)new SASLFrame(challengeBody), (ByteBuffer)null);
        this._frameReceivingState = FrameReceivingState.SASL_RESPONSE_ONLY;
    }

    private void handleSaslError() {
        SaslOutcome outcome = new SaslOutcome();
        outcome.setCode(SaslCode.AUTH);
        this.send((AMQFrame)new SASLFrame(outcome), (ByteBuffer)null);
        this._saslComplete = true;
        this.closeSaslWithFailure();
    }

    @Override
    public int getMaxFrameSize() {
        return this._maxFrameSize;
    }

    Object getReference() {
        return this._reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endpointClosed() {
        try {
            this.performDeleteTasks();
            this.closeReceived();
        }
        finally {
            NamedAddressSpace virtualHost = this.getAddressSpace();
            if (virtualHost != null) {
                virtualHost.deregisterConnection((AMQPConnection)this);
            }
        }
    }

    private void closeConnection() {
        switch (this._connectionState) {
            case AWAITING_OPEN: 
            case OPEN: {
                Close closeToSend = new Close();
                this.sendClose(closeToSend);
                this._connectionState = ConnectionState.CLOSE_SENT;
                break;
            }
        }
    }

    private void closeConnection(Error error) {
        Close close = new Close();
        close.setError(error);
        switch (this._connectionState) {
            case UNOPENED: {
                this.sendOpen(0, 0);
                this.sendClose(close);
                this._connectionState = ConnectionState.CLOSED;
                break;
            }
            case AWAITING_OPEN: 
            case OPEN: {
                this.sendClose(close);
                this._connectionState = ConnectionState.CLOSE_SENT;
            }
            case CLOSE_SENT: 
            case CLOSED: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendFrame(short channel, FrameBody body, QpidByteBuffer payload) {
        if (!this._closedForOutput) {
            ValueWriter<FrameBody> writer = this._describedTypeRegistry.getValueWriter(body);
            int size = writer.writeToBuffer(EMPTY_BYTE_BUFFER);
            QpidByteBuffer payloadDup = payload == null ? null : payload.duplicate();
            int payloadSent = this._maxFrameSize - (size + 9);
            try {
                if (payloadSent < (payload == null ? 0 : payload.remaining())) {
                    if (body instanceof Transfer) {
                        ((Transfer)body).setMore(Boolean.TRUE);
                    }
                    writer = this._describedTypeRegistry.getValueWriter(body);
                    size = writer.writeToBuffer(EMPTY_BYTE_BUFFER);
                    payloadSent = this._maxFrameSize - (size + 9);
                    payloadDup.limit(payloadDup.position() + payloadSent);
                } else {
                    payloadSent = payload == null ? 0 : payload.remaining();
                }
                this.send((AMQFrame)AMQFrame.createAMQFrame(channel, body, payloadDup));
            }
            finally {
                if (payloadDup != null) {
                    payloadDup.dispose();
                }
            }
            return payloadSent;
        }
        return -1;
    }

    void sendFrame(short channel, FrameBody body) {
        this.sendFrame(channel, body, null);
    }

    public ByteBufferSender getSender() {
        return this.getNetwork().getSender();
    }

    public void writerIdle() {
        this.send((AMQFrame)TransportFrame.createAMQFrame((short)0, null));
    }

    public void readerIdle() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AMQPConnection_1_0.this.getEventLogger().message(ConnectionMessages.IDLE_CLOSE((String)"", (boolean)false));
                AMQPConnection_1_0.this.getNetwork().close();
                return null;
            }
        }, this.getAccessControllerContext());
    }

    public void encryptedTransport() {
    }

    private static SaslServerProvider asSaslServerProvider(final SubjectCreator subjectCreator, final ServerNetworkConnection network) {
        return new SaslServerProvider(){

            @Override
            public SaslServer getSaslServer(String mechanism, String fqdn) throws SaslException {
                return subjectCreator.createSaslServer(mechanism, fqdn, network.getPeerPrincipal());
            }
        };
    }

    public String getAddress() {
        return this.getNetwork().getRemoteAddress().toString();
    }

    public void received(final QpidByteBuffer msg) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AMQPConnection_1_0.this.updateLastReadTime();
                try {
                    int remaining;
                    do {
                        remaining = msg.remaining();
                        switch (AMQPConnection_1_0.this._frameReceivingState) {
                            case AMQP_OR_SASL_HEADER: 
                            case AMQP_HEADER: {
                                if (remaining < 8) break;
                                AMQPConnection_1_0.this.processProtocolHeader(msg);
                                break;
                            }
                            case OPEN_ONLY: 
                            case ANY_FRAME: 
                            case SASL_INIT_ONLY: 
                            case SASL_RESPONSE_ONLY: {
                                AMQPConnection_1_0.this._frameHandler.parse(msg);
                                break;
                            }
                        }
                    } while (msg.remaining() != remaining);
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
                catch (StoreException e) {
                    if (AMQPConnection_1_0.this.getAddressSpace().isActive()) {
                        throw new ServerScopedRuntimeException((Throwable)e);
                    }
                    throw new ConnectionScopedRuntimeException((Throwable)e);
                }
                return null;
            }
        }, this.getAccessControllerContext());
    }

    private void processProtocolHeader(QpidByteBuffer msg) {
        if (msg.remaining() >= 8) {
            byte[] header = new byte[8];
            msg.get(header);
            AuthenticationProvider authenticationProvider = this.getPort().getAuthenticationProvider();
            SubjectCreator subjectCreator = authenticationProvider.getSubjectCreator(this.getTransport().isSecure());
            if (Arrays.equals(header, SASL_HEADER)) {
                if (this._saslComplete) {
                    throw new ConnectionScopedRuntimeException("SASL Layer header received after SASL already established");
                }
                this.getSender().send(QpidByteBuffer.wrap((byte[])SASL_HEADER));
                SaslMechanisms mechanisms = new SaslMechanisms();
                ArrayList<Symbol> mechanismsList = new ArrayList<Symbol>();
                for (String name : subjectCreator.getMechanisms()) {
                    mechanismsList.add(Symbol.valueOf(name));
                }
                mechanisms.setSaslServerMechanisms(mechanismsList.toArray(new Symbol[mechanismsList.size()]));
                this.send((AMQFrame)new SASLFrame(mechanisms), (ByteBuffer)null);
                this._frameReceivingState = FrameReceivingState.SASL_INIT_ONLY;
                this._frameHandler = new FrameHandler(this, true);
            } else if (Arrays.equals(header, AMQP_HEADER)) {
                if (!this._saslComplete) {
                    List mechanisms = subjectCreator.getMechanisms();
                    if (mechanisms.contains("EXTERNAL") && this.getNetwork().getPeerPrincipal() != null) {
                        this.setUserPrincipal((Principal)new AuthenticatedPrincipal(this.getNetwork().getPeerPrincipal()));
                    } else if (mechanisms.contains("ANONYMOUS")) {
                        this.setUserPrincipal((Principal)new AuthenticatedPrincipal(((AnonymousAuthenticationManager)authenticationProvider).getAnonymousPrincipal()));
                    } else {
                        this.getNetwork().close();
                    }
                }
                this.getSender().send(QpidByteBuffer.wrap((byte[])AMQP_HEADER));
                this._frameReceivingState = FrameReceivingState.OPEN_ONLY;
                this._frameHandler = new FrameHandler(this, false);
            } else {
                throw new ConnectionScopedRuntimeException("Unknown protocol header");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed() {
        try {
            this.inputClosed();
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception while closing", (Throwable)e);
        }
        finally {
            try {
                this.endpointClosed();
            }
            finally {
                this.markTransportClosed();
            }
        }
    }

    @Override
    public boolean canSend() {
        return true;
    }

    public void send(AMQFrame amqFrame) {
        this.send(amqFrame, (ByteBuffer)null);
    }

    public void send(AMQFrame amqFrame, ByteBuffer buf) {
        this.updateLastWriteTime();
        FRAME_LOGGER.debug("SEND[{}|{}] : {}", new Object[]{this.getNetwork().getRemoteAddress(), amqFrame.getChannel(), amqFrame.getFrameBody()});
        int size = this._frameWriter.send(amqFrame);
        if (size > this.getMaxFrameSize()) {
            throw new OversizeFrameException(amqFrame, size);
        }
    }

    public void send(short channel, FrameBody body) {
        TransportFrame frame = AMQFrame.createAMQFrame(channel, body);
        this.send((AMQFrame)frame);
    }

    @Override
    public void close() {
        this.getAggregateTicker().addTicker((Ticker)new ConnectionClosingTicker(System.currentTimeMillis() + 10000L, this.getNetwork()));
        this.notifyWork();
    }

    public boolean isTransportBlockedForWriting() {
        return this._transportBlockedForWriting;
    }

    public void setTransportBlockedForWriting(boolean blocked) {
        if (this._transportBlockedForWriting != blocked) {
            this._transportBlockedForWriting = blocked;
            this.transportStateChanged();
        }
    }

    public Iterator<Runnable> processPendingIterator() {
        if (this.isIOThread()) {
            return new ProcessPendingIterator();
        }
        return Collections.emptyIterator();
    }

    public boolean hasWork() {
        return this._stateChanged.get();
    }

    public void notifyWork() {
        this._stateChanged.set(true);
        Action<ProtocolEngine> listener = this._workListener.get();
        if (listener != null) {
            listener.performAction((Object)this);
        }
    }

    public void clearWork() {
        this._stateChanged.set(false);
    }

    public void setWorkListener(Action<ProtocolEngine> listener) {
        this._workListener.set(listener);
    }

    public boolean hasSessionWithName(byte[] name) {
        return false;
    }

    public void sendConnectionCloseAsync(AMQConstant cause, String message) {
        Action<ConnectionHandler> action = new Action<ConnectionHandler>(){

            public void performAction(ConnectionHandler object) {
                AMQPConnection_1_0.this.closeConnection();
            }
        };
        this.addAsyncTask(action);
    }

    public void closeSessionAsync(AMQSessionModel<?> session, AMQConstant cause, String message) {
        this.closeSessionAsync((Session_1_0)session, cause, message);
    }

    public void block() {
    }

    public String getRemoteContainerName() {
        return this._remoteContainerId;
    }

    public Collection<? extends Session_1_0> getSessionModels() {
        return Collections.unmodifiableCollection(this._sessions);
    }

    public void unblock() {
    }

    public long getSessionCountLimit() {
        return 0L;
    }

    public boolean isOrderlyClose() {
        return this._orderlyClose.get();
    }

    private void addAsyncTask(Action<ConnectionHandler> action) {
        this._asyncTaskList.add(action);
        this.notifyWork();
    }

    private void sendOpen(int channelMax, int maxFrameSize) {
        Open open = new Open();
        if (this._receivingSessions == null) {
            this._receivingSessions = new Session_1_0[channelMax + 1];
            this._sendingSessions = new Session_1_0[channelMax + 1];
        }
        if (channelMax < this._channelMax) {
            this._channelMax = channelMax;
        }
        open.setChannelMax(UnsignedShort.valueOf((short)channelMax));
        open.setContainerId(this._container.getId());
        open.setMaxFrameSize(UnsignedInteger.valueOf(maxFrameSize));
        open.setIdleTimeOut(UnsignedInteger.valueOf(this._desiredIdleTimeout));
        if (this._properties != null) {
            open.setProperties(this._properties);
        }
        this.sendFrame((short)0, open);
    }

    private void closeWithError(AmqpError amqpError, String errorDescription) {
        Error err = new Error();
        err.setCondition(amqpError);
        err.setDescription(errorDescription);
        this.closeConnection(err);
        this.close();
        this._closedOnOpen = true;
    }

    private Session_1_0 getSession(short channel) {
        Session_1_0 session = this._receivingSessions[channel];
        if (session == null) {
            Error error = new Error();
            error.setCondition(ConnectionError.FRAMING_ERROR);
            error.setDescription("Frame received on channel " + channel + " which is not known as a begun session.");
            this.handleError(error);
        }
        return session;
    }

    private void sendClose(Close closeToSend) {
        this.sendFrame((short)0, closeToSend);
        this.closeSender();
    }

    public String toString() {
        NamedAddressSpace virtualHost = this.getAddressSpace();
        return "Connection_1_0[" + this._connectionId + " " + this.getAddress() + (virtualHost == null ? "" : " vh : " + virtualHost.getName()) + ']';
    }

    private void assertState(FrameReceivingState state) {
        if (this._frameReceivingState != state) {
            throw new ConnectionScopedRuntimeException("Unexpected state, client has sent frame in an illegal order.  Required state: " + (Object)((Object)state) + ", actual state: " + (Object)((Object)this._frameReceivingState));
        }
    }

    public void initialiseHeartbeating(long writerDelay, long readerDelay) {
        super.initialiseHeartbeating(writerDelay, readerDelay);
    }

    private class ProcessPendingIterator
    implements Iterator<Runnable> {
        private final Collection<? extends AMQSessionModel<?>> _sessionsWithPending;
        private Iterator<? extends AMQSessionModel<?>> _sessionIterator;

        private ProcessPendingIterator() {
            this._sessionsWithPending = new ArrayList<Session_1_0>(AMQPConnection_1_0.this.getSessionModels());
            this._sessionIterator = this._sessionsWithPending.iterator();
        }

        @Override
        public boolean hasNext() {
            return !this._sessionsWithPending.isEmpty() || !AMQPConnection_1_0.this._asyncTaskList.isEmpty();
        }

        @Override
        public Runnable next() {
            if (!this._sessionsWithPending.isEmpty()) {
                if (!this._sessionIterator.hasNext()) {
                    this._sessionIterator = this._sessionsWithPending.iterator();
                }
                final AMQSessionModel<?> session = this._sessionIterator.next();
                return new Runnable(){

                    @Override
                    public void run() {
                        if (!session.processPending()) {
                            ProcessPendingIterator.this._sessionIterator.remove();
                        }
                    }
                };
            }
            if (!AMQPConnection_1_0.this._asyncTaskList.isEmpty()) {
                final Action asyncAction = (Action)AMQPConnection_1_0.this._asyncTaskList.poll();
                return new Runnable(){

                    @Override
                    public void run() {
                        asyncAction.performAction((Object)AMQPConnection_1_0.this);
                    }
                };
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static enum FrameReceivingState {
        AMQP_OR_SASL_HEADER,
        SASL_INIT_ONLY,
        SASL_RESPONSE_ONLY,
        AMQP_HEADER,
        OPEN_ONLY,
        ANY_FRAME,
        CLOSED;

    }
}

