/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;

public class Container {
    private static final AtomicInteger CONTAINER_ID = new AtomicInteger(0);
    private String _id;

    public Container() {
        String hostname;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "127.0.0.1";
        }
        String hackForPid = ManagementFactory.getRuntimeMXBean().getName();
        String pid = hackForPid != null && hackForPid.contains("@") ? hackForPid.split("@")[0] : "unknown";
        this._id = hostname + '(' + pid + ')' + ':' + CONTAINER_ID.incrementAndGet();
    }

    public Container(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }
}

