/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;

public class Delivery {
    private boolean _complete;
    private boolean _settled;
    private final UnsignedInteger _deliveryId;
    private final Binary _deliveryTag;
    private final LinkEndpoint _linkEndpoint;

    public Delivery(Transfer transfer, LinkEndpoint endpoint) {
        this._settled = Boolean.TRUE.equals(transfer.getSettled());
        this._deliveryId = transfer.getDeliveryId();
        this._deliveryTag = transfer.getDeliveryTag();
        this._linkEndpoint = endpoint;
        this.addTransfer(transfer);
    }

    public boolean isComplete() {
        return this._complete;
    }

    public void setComplete(boolean complete) {
        this._complete = complete;
    }

    public boolean isSettled() {
        return this._settled;
    }

    public void setSettled(boolean settled) {
        this._settled = settled;
    }

    public void addTransfer(Transfer transfer) {
        if (Boolean.TRUE.equals(transfer.getAborted()) || !Boolean.TRUE.equals(transfer.getMore())) {
            this.setComplete(true);
        }
        if (Boolean.TRUE.equals(transfer.getSettled())) {
            this.setSettled(true);
        }
    }

    public UnsignedInteger getDeliveryId() {
        return this._deliveryId;
    }

    public LinkEndpoint getLinkEndpoint() {
        return this._linkEndpoint;
    }

    public Binary getDeliveryTag() {
        return this._deliveryTag;
    }
}

