/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_to_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoder;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.Section;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedByte;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValue;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Data;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Properties;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

@PluggableService
public class MessageConverter_Internal_to_v1_0
extends MessageConverter_to_1_0<InternalMessage> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public Class<InternalMessage> getInputClass() {
        return InternalMessage.class;
    }

    @Override
    protected MessageMetaData_1_0 convertMetaData(InternalMessage serverMessage, Section bodySection, SectionEncoder sectionEncoder) {
        String userId;
        ArrayList<Section> sections = new ArrayList<Section>(3);
        Header header = new Header();
        header.setDurable(serverMessage.isPersistent());
        header.setPriority(UnsignedByte.valueOf(serverMessage.getMessageHeader().getPriority()));
        if (serverMessage.getExpiration() != 0L && serverMessage.getArrivalTime() != 0L && serverMessage.getExpiration() >= serverMessage.getArrivalTime()) {
            header.setTtl(UnsignedInteger.valueOf(serverMessage.getExpiration() - serverMessage.getArrivalTime()));
        }
        sections.add(header);
        Properties properties = new Properties();
        properties.setCorrelationId(serverMessage.getMessageHeader().getCorrelationId());
        properties.setCreationTime(new Date(serverMessage.getMessageHeader().getTimestamp()));
        properties.setMessageId(serverMessage.getMessageHeader().getMessageId());
        if (bodySection instanceof Data) {
            properties.setContentType(Symbol.valueOf(serverMessage.getMessageHeader().getMimeType()));
        }
        if ((userId = serverMessage.getMessageHeader().getUserId()) != null) {
            properties.setUserId(new Binary(userId.getBytes(UTF_8)));
        }
        properties.setReplyTo(serverMessage.getMessageHeader().getReplyTo());
        sections.add(properties);
        if (!serverMessage.getMessageHeader().getHeaderNames().isEmpty()) {
            ApplicationProperties applicationProperties = new ApplicationProperties(serverMessage.getMessageHeader().getHeaderMap());
            sections.add(applicationProperties);
        }
        if (bodySection != null) {
            sections.add(bodySection);
        }
        return new MessageMetaData_1_0(sections, sectionEncoder);
    }

    @Override
    protected Section getBodySection(InternalMessage serverMessage) {
        return this.convertToBody(serverMessage.getMessageBody());
    }

    public String getType() {
        return "Internal to v1-0";
    }

    public Section convertToBody(Object object) {
        if (object instanceof String) {
            return new AmqpValue(object);
        }
        if (object instanceof byte[]) {
            return new Data(new Binary((byte[])object));
        }
        if (object instanceof Map) {
            return new AmqpValue(MessageConverter_to_1_0.fixMapValues((Map)object));
        }
        if (object instanceof List) {
            return new AmqpValue(MessageConverter_to_1_0.fixListValues((List)object));
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bytesOut);
            os.writeObject(object);
            return new Data(new Binary(bytesOut.toByteArray()));
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
    }
}

