/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;

public class CharTypeConstructor
implements TypeConstructor {
    private static final CharTypeConstructor INSTANCE = new CharTypeConstructor();

    public static CharTypeConstructor getInstance() {
        return INSTANCE;
    }

    private CharTypeConstructor() {
    }

    public Object construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.remaining() >= 4) {
            int codePoint = in.getInt();
            char[] chars = Character.toChars(codePoint);
            if (chars.length == 1) {
                return Character.valueOf(chars[0]);
            }
            return chars;
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct char: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

