/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public abstract class FixedSixteenWriter<T>
implements ValueWriter<T> {
    private int _written = 17;
    private long _msb;
    private long _lsb;

    @Override
    public final int writeToBuffer(QpidByteBuffer buffer) {
        int remaining = buffer.remaining();
        int written = this._written;
        switch (written) {
            case 0: {
                if (!buffer.hasRemaining()) break;
                buffer.put(this.getFormatCode());
                --remaining;
                written = 1;
            }
            case 1: {
                if (remaining >= 8) {
                    buffer.putLong(this._msb);
                    written = 9;
                    break;
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (remaining >= 4) {
                    buffer.putInt((int)(this._msb >> (5 - written << 3) & 0xFFFFFFFFFFFFFFFFL));
                    remaining -= 4;
                    written += 4;
                }
            }
            case 6: 
            case 7: {
                if (remaining >= 2 && written <= 7) {
                    buffer.putShort((short)(this._msb >> (7 - written << 3) & 0xFFFFL));
                    remaining -= 2;
                    written += 2;
                }
            }
            case 8: {
                if (remaining < 1 || written == 9) break;
                buffer.put((byte)(this._msb >> (8 - written << 3) & 0xFFL));
                ++written;
            }
        }
        if (remaining != 0) {
            switch (written) {
                case 9: {
                    if (remaining >= 8) {
                        buffer.putLong(this._lsb);
                        written = 17;
                        break;
                    }
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (remaining >= 4) {
                        buffer.putInt((int)(this._lsb >> (13 - written << 3) & 0xFFFFFFFFFFFFFFFFL));
                        remaining -= 4;
                        written += 4;
                    }
                }
                case 14: 
                case 15: {
                    if (remaining >= 2 && written <= 15) {
                        buffer.putShort((short)(this._lsb >> (15 - written << 3) & 0xFFFFL));
                        remaining -= 2;
                        written += 2;
                    }
                }
                case 16: {
                    if (remaining < 1 || written == 17) break;
                    buffer.put((byte)(this._msb >> (16 - written << 3) & 0xFFL));
                    ++written;
                }
            }
        }
        this._written = written;
        return 17;
    }

    abstract byte getFormatCode();

    @Override
    public final void setValue(T value) {
        this._written = 0;
        this._msb = this.convertValueToMSB(value);
        this._lsb = this.convertValueToLSB(value);
    }

    abstract long convertValueToMSB(T var1);

    abstract long convertValueToLSB(T var1);

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public final boolean isComplete() {
        return this._written == 17;
    }
}

