/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;

public abstract class FixedTwoWriter<T>
implements ValueWriter<T> {
    private int _written = 3;
    private short _value;

    @Override
    public int writeToBuffer(QpidByteBuffer buffer) {
        switch (this._written) {
            case 0: {
                if (!buffer.hasRemaining()) break;
                buffer.put(this.getFormatCode());
            }
            case 1: {
                if (buffer.remaining() > 1) {
                    buffer.putShort(this._value);
                    this._written = 3;
                    break;
                }
                if (buffer.hasRemaining()) {
                    buffer.put((byte)(0xFF & this._value >> 8));
                    this._written = 2;
                    break;
                }
                this._written = 1;
                break;
            }
            case 2: {
                if (!buffer.hasRemaining()) break;
                buffer.put((byte)(0xFF & this._value));
            }
        }
        return 3;
    }

    @Override
    public final void setValue(T value) {
        this._written = 0;
        this._value = this.convertValueToShort(value);
    }

    abstract short convertValueToShort(T var1);

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this._written == 3;
    }

    abstract byte getFormatCode();
}

