/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;

public class FloatTypeConstructor
implements TypeConstructor {
    private static final FloatTypeConstructor INSTANCE = new FloatTypeConstructor();

    public static FloatTypeConstructor getInstance() {
        return INSTANCE;
    }

    private FloatTypeConstructor() {
    }

    public Object construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.remaining() >= 4) {
            return Float.valueOf(in.getFloat());
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct float: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

