/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.framing.AMQFrame;
import org.apache.qpid.transport.ByteBufferSender;

public class FrameWriter {
    private final ByteBufferSender _sender;
    private final ValueWriter.Registry _registry;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public FrameWriter(ValueWriter.Registry registry, ByteBufferSender sender) {
        this._registry = registry;
        this._sender = sender;
    }

    public <T> int send(AMQFrame<T> frame) {
        int bodySize;
        ValueWriter<T> typeWriter;
        QpidByteBuffer payload = frame.getPayload() == null ? null : frame.getPayload().duplicate();
        int payloadLength = payload == null ? 0 : payload.remaining();
        T frameBody = frame.getFrameBody();
        ValueWriter<T> valueWriter = typeWriter = frameBody == null ? null : this._registry.getValueWriter(frameBody);
        if (typeWriter == null) {
            bodySize = 8;
        } else {
            typeWriter.setValue(frame.getFrameBody());
            QpidByteBuffer qpidByteBuffer = QpidByteBuffer.wrap((byte[])EMPTY_BYTE_ARRAY);
            bodySize = typeWriter.writeToBuffer(qpidByteBuffer) + 8;
        }
        QpidByteBuffer body = QpidByteBuffer.allocate((boolean)this._sender.isDirectBufferPreferred(), (int)bodySize);
        int totalSize = bodySize + payloadLength;
        body.putInt(totalSize);
        body.put((byte)2);
        body.put(frame.getFrameType());
        body.putShort(frame.getChannel());
        if (typeWriter != null) {
            typeWriter.writeToBuffer(body);
        }
        body.flip();
        this._sender.send(body);
        body.dispose();
        if (payload != null) {
            this._sender.send(payload);
            payload.dispose();
        }
        return totalSize;
    }
}

