/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;

public class SmallUIntConstructor
implements TypeConstructor {
    private static final SmallUIntConstructor INSTANCE = new SmallUIntConstructor();

    public static SmallUIntConstructor getInstance() {
        return INSTANCE;
    }

    private SmallUIntConstructor() {
    }

    public Object construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.hasRemaining()) {
            byte b = in.get();
            return UnsignedInteger.valueOf(b & 0xFF);
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct uint: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

