/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.BinaryString;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.VariableWidthTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;

public class SymbolTypeConstructor
extends VariableWidthTypeConstructor {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final ConcurrentMap<BinaryString, Symbol> SYMBOL_MAP = new ConcurrentHashMap<BinaryString, Symbol>(2048);

    public static SymbolTypeConstructor getInstance(int i) {
        return new SymbolTypeConstructor(i);
    }

    private SymbolTypeConstructor(int size) {
        super(size);
    }

    @Override
    public Object construct(QpidByteBuffer in, boolean isCopy, ValueHandler handler) throws AmqpErrorException {
        QpidByteBuffer dup;
        BinaryString binaryStr;
        int size = this.getSize() == 1 ? in.get() & 0xFF : in.getInt();
        if (in.hasArray()) {
            binaryStr = new BinaryString(in.array(), in.arrayOffset() + in.position(), size);
        } else {
            byte[] b = new byte[in.remaining()];
            dup = in.duplicate();
            dup.get(b);
            dup.dispose();
            binaryStr = new BinaryString(b, 0, b.length);
        }
        Symbol symbolVal = (Symbol)SYMBOL_MAP.get(binaryStr);
        if (symbolVal == null) {
            dup = in.duplicate();
            dup.limit(in.position() + size);
            CharBuffer charBuf = dup.decode(ASCII);
            dup.dispose();
            symbolVal = Symbol.getSymbol(charBuf.toString());
            byte[] data = new byte[size];
            in.get(data);
            binaryStr = new BinaryString(data, 0, size);
            SYMBOL_MAP.putIfAbsent(binaryStr, symbolVal);
        } else {
            in.position(in.position() + size);
        }
        return symbolVal;
    }
}

