/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;

public class ULongTypeConstructor
implements TypeConstructor {
    private static final ULongTypeConstructor INSTANCE = new ULongTypeConstructor();

    public static ULongTypeConstructor getInstance() {
        return INSTANCE;
    }

    private ULongTypeConstructor() {
    }

    public Object construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.remaining() >= 8) {
            long l = in.getLong();
            return UnsignedLong.valueOf(l);
        }
        Error error = new Error();
        error.setCondition(ConnectionError.FRAMING_ERROR);
        error.setDescription("Cannot construct ulong: insufficient input data");
        throw new AmqpErrorException(error);
    }
}

