/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.FixedFourWriter;
import org.apache.qpid.server.protocol.v1_0.codec.FixedOneWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;

public class UnsignedIntegerWriter
implements ValueWriter<UnsignedInteger> {
    private static final byte EIGHT_BYTE_FORMAT_CODE = 112;
    private static final byte ONE_BYTE_FORMAT_CODE = 82;
    private static final byte ZERO_BYTE_FORMAT_CODE = 67;
    private ValueWriter<UnsignedInteger> _delegate;
    private final FixedFourWriter<UnsignedInteger> _eightByteWriter = new FixedFourWriter<UnsignedInteger>(){

        @Override
        byte getFormatCode() {
            return 112;
        }

        @Override
        int convertValueToInt(UnsignedInteger value) {
            return value.intValue();
        }
    };
    private final ValueWriter<UnsignedInteger> _oneByteWriter = new FixedOneWriter<UnsignedInteger>(){

        @Override
        protected byte getFormatCode() {
            return 82;
        }

        @Override
        protected byte convertToByte(UnsignedInteger value) {
            return value.byteValue();
        }
    };
    private final ValueWriter<UnsignedInteger> _zeroByteWriter = new ValueWriter<UnsignedInteger>(){
        private boolean _complete;

        @Override
        public int writeToBuffer(QpidByteBuffer buffer) {
            if (!this._complete && buffer.hasRemaining()) {
                buffer.put((byte)67);
                this._complete = true;
            }
            return 1;
        }

        @Override
        public void setValue(UnsignedInteger uint) {
            this._complete = false;
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public boolean isComplete() {
            return this._complete;
        }
    };
    private static ValueWriter.Factory<UnsignedInteger> FACTORY = new ValueWriter.Factory<UnsignedInteger>(){

        @Override
        public ValueWriter<UnsignedInteger> newInstance(ValueWriter.Registry registry) {
            return new UnsignedIntegerWriter();
        }
    };

    @Override
    public int writeToBuffer(QpidByteBuffer buffer) {
        return this._delegate.writeToBuffer(buffer);
    }

    @Override
    public void setValue(UnsignedInteger uint) {
        this._delegate = uint.equals(UnsignedInteger.ZERO) ? this._zeroByteWriter : (uint.compareTo(UnsignedInteger.valueOf(256)) < 0 ? this._oneByteWriter : this._eightByteWriter);
        this._delegate.setValue(uint);
    }

    @Override
    public boolean isComplete() {
        return this._delegate.isComplete();
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(UnsignedInteger.class, FACTORY);
    }
}

