/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.FixedEightWriter;
import org.apache.qpid.server.protocol.v1_0.codec.FixedOneWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;

public class UnsignedLongWriter
implements ValueWriter<UnsignedLong> {
    private static final byte EIGHT_BYTE_FORMAT_CODE = -128;
    private static final byte ONE_BYTE_FORMAT_CODE = 83;
    private static final byte ZERO_BYTE_FORMAT_CODE = 68;
    private ValueWriter<UnsignedLong> _delegate;
    private final FixedEightWriter<UnsignedLong> _eightByteWriter = new FixedEightWriter<UnsignedLong>(){

        @Override
        byte getFormatCode() {
            return -128;
        }

        @Override
        long convertValueToLong(UnsignedLong value) {
            return value.longValue();
        }
    };
    private final ValueWriter<UnsignedLong> _oneByteWriter = new FixedOneWriter<UnsignedLong>(){

        @Override
        protected byte getFormatCode() {
            return 83;
        }

        @Override
        protected byte convertToByte(UnsignedLong value) {
            return value.byteValue();
        }
    };
    private final ValueWriter<UnsignedLong> _zeroByteWriter = new ValueWriter<UnsignedLong>(){
        private boolean _complete;

        @Override
        public int writeToBuffer(QpidByteBuffer buffer) {
            if (!this._complete && buffer.hasRemaining()) {
                buffer.put((byte)68);
                this._complete = true;
            }
            return 1;
        }

        @Override
        public void setValue(UnsignedLong ulong) {
            this._complete = false;
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public boolean isComplete() {
            return this._complete;
        }
    };
    private static ValueWriter.Factory<UnsignedLong> FACTORY = new ValueWriter.Factory<UnsignedLong>(){

        @Override
        public ValueWriter<UnsignedLong> newInstance(ValueWriter.Registry registry) {
            return new UnsignedLongWriter();
        }
    };

    public static void register(ValueWriter.Registry registry) {
        registry.register(UnsignedLong.class, FACTORY);
    }

    @Override
    public int writeToBuffer(QpidByteBuffer buffer) {
        return this._delegate.writeToBuffer(buffer);
    }

    @Override
    public void setValue(UnsignedLong ulong) {
        this._delegate = ulong.equals(UnsignedLong.ZERO) ? this._zeroByteWriter : ((ulong.longValue() & 0xFFL) == ulong.longValue() ? this._oneByteWriter : this._eightByteWriter);
        this._delegate.setValue(ulong);
    }

    @Override
    public boolean isComplete() {
        return this._delegate.isComplete();
    }

    @Override
    public boolean isCacheable() {
        return false;
    }
}

