/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transaction.codec;

import org.apache.qpid.server.protocol.v1_0.codec.AbstractDescribedTypeWriter;
import org.apache.qpid.server.protocol.v1_0.codec.AbstractListWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.transaction.Discharge;

public class DischargeWriter
extends AbstractDescribedTypeWriter<Discharge> {
    private Discharge _value;
    private int _count = -1;
    private static ValueWriter.Factory<Discharge> FACTORY = new ValueWriter.Factory<Discharge>(){

        @Override
        public ValueWriter<Discharge> newInstance(ValueWriter.Registry registry) {
            return new DischargeWriter(registry);
        }
    };

    public DischargeWriter(ValueWriter.Registry registry) {
        super(registry);
    }

    @Override
    protected void onSetValue(Discharge value) {
        this._value = value;
        this._count = this.calculateCount();
    }

    private int calculateCount() {
        if (this._value.getFail() != null) {
            return 2;
        }
        if (this._value.getTxnId() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void clear() {
        this._value = null;
        this._count = -1;
    }

    @Override
    protected Object getDescriptor() {
        return UnsignedLong.valueOf(50L);
    }

    @Override
    protected ValueWriter createDescribedWriter() {
        Writer writer = new Writer(this.getRegistry());
        writer.setValue(this._value);
        return writer;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Discharge.class, FACTORY);
    }

    private class Writer
    extends AbstractListWriter<Discharge> {
        private int _field;

        public Writer(ValueWriter.Registry registry) {
            super(registry);
        }

        @Override
        protected void onSetValue(Discharge value) {
            this.reset();
        }

        @Override
        protected int getCount() {
            return DischargeWriter.this._count;
        }

        @Override
        protected boolean hasNext() {
            return this._field < DischargeWriter.this._count;
        }

        @Override
        protected Object next() {
            switch (this._field++) {
                case 0: {
                    return DischargeWriter.this._value.getTxnId();
                }
                case 1: {
                    return DischargeWriter.this._value.getFail();
                }
            }
            return null;
        }

        @Override
        protected void clear() {
        }

        @Override
        protected void reset() {
            this._field = 0;
        }
    }
}

